/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration information of a delta time session window.
 * </p>
 * <p>
 * <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html"> <code>DeltaTime</code>
 * </a> specifies a time interval. You can use <code>DeltaTime</code> to create dataset contents with data that has
 * arrived in the data store since the last execution. For an example of <code>DeltaTime</code>, see <a
 * href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/automate-create-dataset.html#automate-example6">
 * Creating a SQL dataset with a delta window (CLI)</a> in the <i>IoT Analytics User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeltaTimeSessionWindowConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeltaTimeSessionWindowConfiguration.Builder, DeltaTimeSessionWindowConfiguration> {
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutInMinutes").getter(getter(DeltaTimeSessionWindowConfiguration::timeoutInMinutes))
            .setter(setter(Builder::timeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutInMinutes;

    private DeltaTimeSessionWindowConfiguration(BuilderImpl builder) {
        this.timeoutInMinutes = builder.timeoutInMinutes;
    }

    /**
     * <p>
     * A time interval. You can use <code>timeoutInMinutes</code> so that IoT Analytics can batch up late data
     * notifications that have been generated since the last execution. IoT Analytics sends one batch of notifications
     * to Amazon CloudWatch Events at one time.
     * </p>
     * <p>
     * For more information about how to write a timestamp expression, see <a
     * href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and Operators</a>, in the
     * <i>Presto 0.172 Documentation</i>.
     * </p>
     * 
     * @return A time interval. You can use <code>timeoutInMinutes</code> so that IoT Analytics can batch up late data
     *         notifications that have been generated since the last execution. IoT Analytics sends one batch of
     *         notifications to Amazon CloudWatch Events at one time.</p>
     *         <p>
     *         For more information about how to write a timestamp expression, see <a
     *         href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and Operators</a>,
     *         in the <i>Presto 0.172 Documentation</i>.
     */
    public final Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeltaTimeSessionWindowConfiguration)) {
            return false;
        }
        DeltaTimeSessionWindowConfiguration other = (DeltaTimeSessionWindowConfiguration) obj;
        return Objects.equals(timeoutInMinutes(), other.timeoutInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeltaTimeSessionWindowConfiguration").add("TimeoutInMinutes", timeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutInMinutes":
            return Optional.ofNullable(clazz.cast(timeoutInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutInMinutes", TIMEOUT_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeltaTimeSessionWindowConfiguration, T> g) {
        return obj -> g.apply((DeltaTimeSessionWindowConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeltaTimeSessionWindowConfiguration> {
        /**
         * <p>
         * A time interval. You can use <code>timeoutInMinutes</code> so that IoT Analytics can batch up late data
         * notifications that have been generated since the last execution. IoT Analytics sends one batch of
         * notifications to Amazon CloudWatch Events at one time.
         * </p>
         * <p>
         * For more information about how to write a timestamp expression, see <a
         * href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and Operators</a>, in
         * the <i>Presto 0.172 Documentation</i>.
         * </p>
         * 
         * @param timeoutInMinutes
         *        A time interval. You can use <code>timeoutInMinutes</code> so that IoT Analytics can batch up late
         *        data notifications that have been generated since the last execution. IoT Analytics sends one batch of
         *        notifications to Amazon CloudWatch Events at one time.</p>
         *        <p>
         *        For more information about how to write a timestamp expression, see <a
         *        href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and
         *        Operators</a>, in the <i>Presto 0.172 Documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeltaTimeSessionWindowConfiguration model) {
            timeoutInMinutes(model.timeoutInMinutes);
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        @Override
        public DeltaTimeSessionWindowConfiguration build() {
            return new DeltaTimeSessionWindowConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
