/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about your data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreStorageSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastoreStorageSummary.Builder, DatastoreStorageSummary> {
    private static final SdkField<ServiceManagedDatastoreS3StorageSummary> SERVICE_MANAGED_S3_FIELD = SdkField
            .<ServiceManagedDatastoreS3StorageSummary> builder(MarshallingType.SDK_POJO).memberName("serviceManagedS3")
            .getter(getter(DatastoreStorageSummary::serviceManagedS3)).setter(setter(Builder::serviceManagedS3))
            .constructor(ServiceManagedDatastoreS3StorageSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedS3").build()).build();

    private static final SdkField<CustomerManagedDatastoreS3StorageSummary> CUSTOMER_MANAGED_S3_FIELD = SdkField
            .<CustomerManagedDatastoreS3StorageSummary> builder(MarshallingType.SDK_POJO).memberName("customerManagedS3")
            .getter(getter(DatastoreStorageSummary::customerManagedS3)).setter(setter(Builder::customerManagedS3))
            .constructor(CustomerManagedDatastoreS3StorageSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3").build()).build();

    private static final SdkField<DatastoreIotSiteWiseMultiLayerStorageSummary> IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD = SdkField
            .<DatastoreIotSiteWiseMultiLayerStorageSummary> builder(MarshallingType.SDK_POJO)
            .memberName("iotSiteWiseMultiLayerStorage")
            .getter(getter(DatastoreStorageSummary::iotSiteWiseMultiLayerStorage))
            .setter(setter(Builder::iotSiteWiseMultiLayerStorage))
            .constructor(DatastoreIotSiteWiseMultiLayerStorageSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWiseMultiLayerStorage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_MANAGED_S3_FIELD,
            CUSTOMER_MANAGED_S3_FIELD, IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceManagedDatastoreS3StorageSummary serviceManagedS3;

    private final CustomerManagedDatastoreS3StorageSummary customerManagedS3;

    private final DatastoreIotSiteWiseMultiLayerStorageSummary iotSiteWiseMultiLayerStorage;

    private DatastoreStorageSummary(BuilderImpl builder) {
        this.serviceManagedS3 = builder.serviceManagedS3;
        this.customerManagedS3 = builder.customerManagedS3;
        this.iotSiteWiseMultiLayerStorage = builder.iotSiteWiseMultiLayerStorage;
    }

    /**
     * <p>
     * Used to store data in an Amazon S3 bucket managed by IoT Analytics.
     * </p>
     * 
     * @return Used to store data in an Amazon S3 bucket managed by IoT Analytics.
     */
    public final ServiceManagedDatastoreS3StorageSummary serviceManagedS3() {
        return serviceManagedS3;
    }

    /**
     * <p>
     * Used to store data in an Amazon S3 bucket managed by IoT Analytics.
     * </p>
     * 
     * @return Used to store data in an Amazon S3 bucket managed by IoT Analytics.
     */
    public final CustomerManagedDatastoreS3StorageSummary customerManagedS3() {
        return customerManagedS3;
    }

    /**
     * <p>
     * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
     * </p>
     * 
     * @return Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
     */
    public final DatastoreIotSiteWiseMultiLayerStorageSummary iotSiteWiseMultiLayerStorage() {
        return iotSiteWiseMultiLayerStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(iotSiteWiseMultiLayerStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreStorageSummary)) {
            return false;
        }
        DatastoreStorageSummary other = (DatastoreStorageSummary) obj;
        return Objects.equals(serviceManagedS3(), other.serviceManagedS3())
                && Objects.equals(customerManagedS3(), other.customerManagedS3())
                && Objects.equals(iotSiteWiseMultiLayerStorage(), other.iotSiteWiseMultiLayerStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastoreStorageSummary").add("ServiceManagedS3", serviceManagedS3())
                .add("CustomerManagedS3", customerManagedS3())
                .add("IotSiteWiseMultiLayerStorage", iotSiteWiseMultiLayerStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceManagedS3":
            return Optional.ofNullable(clazz.cast(serviceManagedS3()));
        case "customerManagedS3":
            return Optional.ofNullable(clazz.cast(customerManagedS3()));
        case "iotSiteWiseMultiLayerStorage":
            return Optional.ofNullable(clazz.cast(iotSiteWiseMultiLayerStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceManagedS3", SERVICE_MANAGED_S3_FIELD);
        map.put("customerManagedS3", CUSTOMER_MANAGED_S3_FIELD);
        map.put("iotSiteWiseMultiLayerStorage", IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatastoreStorageSummary, T> g) {
        return obj -> g.apply((DatastoreStorageSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreStorageSummary> {
        /**
         * <p>
         * Used to store data in an Amazon S3 bucket managed by IoT Analytics.
         * </p>
         * 
         * @param serviceManagedS3
         *        Used to store data in an Amazon S3 bucket managed by IoT Analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceManagedS3(ServiceManagedDatastoreS3StorageSummary serviceManagedS3);

        /**
         * <p>
         * Used to store data in an Amazon S3 bucket managed by IoT Analytics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceManagedDatastoreS3StorageSummary.Builder} avoiding the need to create one manually via
         * {@link ServiceManagedDatastoreS3StorageSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceManagedDatastoreS3StorageSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #serviceManagedS3(ServiceManagedDatastoreS3StorageSummary)}.
         * 
         * @param serviceManagedS3
         *        a consumer that will call methods on {@link ServiceManagedDatastoreS3StorageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceManagedS3(ServiceManagedDatastoreS3StorageSummary)
         */
        default Builder serviceManagedS3(Consumer<ServiceManagedDatastoreS3StorageSummary.Builder> serviceManagedS3) {
            return serviceManagedS3(ServiceManagedDatastoreS3StorageSummary.builder().applyMutation(serviceManagedS3).build());
        }

        /**
         * <p>
         * Used to store data in an Amazon S3 bucket managed by IoT Analytics.
         * </p>
         * 
         * @param customerManagedS3
         *        Used to store data in an Amazon S3 bucket managed by IoT Analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedS3(CustomerManagedDatastoreS3StorageSummary customerManagedS3);

        /**
         * <p>
         * Used to store data in an Amazon S3 bucket managed by IoT Analytics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomerManagedDatastoreS3StorageSummary.Builder} avoiding the need to create one manually via
         * {@link CustomerManagedDatastoreS3StorageSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerManagedDatastoreS3StorageSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #customerManagedS3(CustomerManagedDatastoreS3StorageSummary)}.
         * 
         * @param customerManagedS3
         *        a consumer that will call methods on {@link CustomerManagedDatastoreS3StorageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedS3(CustomerManagedDatastoreS3StorageSummary)
         */
        default Builder customerManagedS3(Consumer<CustomerManagedDatastoreS3StorageSummary.Builder> customerManagedS3) {
            return customerManagedS3(CustomerManagedDatastoreS3StorageSummary.builder().applyMutation(customerManagedS3).build());
        }

        /**
         * <p>
         * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
         * </p>
         * 
         * @param iotSiteWiseMultiLayerStorage
         *        Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorageSummary iotSiteWiseMultiLayerStorage);

        /**
         * <p>
         * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatastoreIotSiteWiseMultiLayerStorageSummary.Builder} avoiding the need to create one manually via
         * {@link DatastoreIotSiteWiseMultiLayerStorageSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatastoreIotSiteWiseMultiLayerStorageSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorageSummary)}.
         * 
         * @param iotSiteWiseMultiLayerStorage
         *        a consumer that will call methods on {@link DatastoreIotSiteWiseMultiLayerStorageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorageSummary)
         */
        default Builder iotSiteWiseMultiLayerStorage(
                Consumer<DatastoreIotSiteWiseMultiLayerStorageSummary.Builder> iotSiteWiseMultiLayerStorage) {
            return iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorageSummary.builder()
                    .applyMutation(iotSiteWiseMultiLayerStorage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceManagedDatastoreS3StorageSummary serviceManagedS3;

        private CustomerManagedDatastoreS3StorageSummary customerManagedS3;

        private DatastoreIotSiteWiseMultiLayerStorageSummary iotSiteWiseMultiLayerStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreStorageSummary model) {
            serviceManagedS3(model.serviceManagedS3);
            customerManagedS3(model.customerManagedS3);
            iotSiteWiseMultiLayerStorage(model.iotSiteWiseMultiLayerStorage);
        }

        public final ServiceManagedDatastoreS3StorageSummary.Builder getServiceManagedS3() {
            return serviceManagedS3 != null ? serviceManagedS3.toBuilder() : null;
        }

        public final void setServiceManagedS3(ServiceManagedDatastoreS3StorageSummary.BuilderImpl serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3 != null ? serviceManagedS3.build() : null;
        }

        @Override
        public final Builder serviceManagedS3(ServiceManagedDatastoreS3StorageSummary serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3;
            return this;
        }

        public final CustomerManagedDatastoreS3StorageSummary.Builder getCustomerManagedS3() {
            return customerManagedS3 != null ? customerManagedS3.toBuilder() : null;
        }

        public final void setCustomerManagedS3(CustomerManagedDatastoreS3StorageSummary.BuilderImpl customerManagedS3) {
            this.customerManagedS3 = customerManagedS3 != null ? customerManagedS3.build() : null;
        }

        @Override
        public final Builder customerManagedS3(CustomerManagedDatastoreS3StorageSummary customerManagedS3) {
            this.customerManagedS3 = customerManagedS3;
            return this;
        }

        public final DatastoreIotSiteWiseMultiLayerStorageSummary.Builder getIotSiteWiseMultiLayerStorage() {
            return iotSiteWiseMultiLayerStorage != null ? iotSiteWiseMultiLayerStorage.toBuilder() : null;
        }

        public final void setIotSiteWiseMultiLayerStorage(
                DatastoreIotSiteWiseMultiLayerStorageSummary.BuilderImpl iotSiteWiseMultiLayerStorage) {
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage != null ? iotSiteWiseMultiLayerStorage.build()
                    : null;
        }

        @Override
        public final Builder iotSiteWiseMultiLayerStorage(
                DatastoreIotSiteWiseMultiLayerStorageSummary iotSiteWiseMultiLayerStorage) {
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage;
            return this;
        }

        @Override
        public DatastoreStorageSummary build() {
            return new DatastoreStorageSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
