/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the action that automatically creates the dataset's contents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetActionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetActionSummary.Builder, DatasetActionSummary> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(DatasetActionSummary::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(DatasetActionSummary::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            ACTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final String actionType;

    private DatasetActionSummary(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.actionType = builder.actionType;
    }

    /**
     * <p>
     * The name of the action that automatically creates the dataset's contents.
     * </p>
     * 
     * @return The name of the action that automatically creates the dataset's contents.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The type of action by which the dataset's contents are automatically created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link DatasetActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action by which the dataset's contents are automatically created.
     * @see DatasetActionType
     */
    public final DatasetActionType actionType() {
        return DatasetActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of action by which the dataset's contents are automatically created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link DatasetActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action by which the dataset's contents are automatically created.
     * @see DatasetActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetActionSummary)) {
            return false;
        }
        DatasetActionSummary other = (DatasetActionSummary) obj;
        return Objects.equals(actionName(), other.actionName())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetActionSummary").add("ActionName", actionName()).add("ActionType", actionTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionName", ACTION_NAME_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetActionSummary, T> g) {
        return obj -> g.apply((DatasetActionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetActionSummary> {
        /**
         * <p>
         * The name of the action that automatically creates the dataset's contents.
         * </p>
         * 
         * @param actionName
         *        The name of the action that automatically creates the dataset's contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The type of action by which the dataset's contents are automatically created.
         * </p>
         * 
         * @param actionType
         *        The type of action by which the dataset's contents are automatically created.
         * @see DatasetActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of action by which the dataset's contents are automatically created.
         * </p>
         * 
         * @param actionType
         *        The type of action by which the dataset's contents are automatically created.
         * @see DatasetActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetActionType
         */
        Builder actionType(DatasetActionType actionType);
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private String actionType;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetActionSummary model) {
            actionName(model.actionName);
            actionType(model.actionType);
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(DatasetActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        @Override
        public DatasetActionSummary build() {
            return new DatasetActionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
