/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.JsonConfiguration;
import software.amazon.awssdk.services.iotanalytics.model.ParquetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileFormatConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileFormatConfiguration> {
    private static final SdkField<JsonConfiguration> JSON_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jsonConfiguration").getter(FileFormatConfiguration.getter(FileFormatConfiguration::jsonConfiguration)).setter(FileFormatConfiguration.setter(Builder::jsonConfiguration)).constructor(JsonConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonConfiguration").build()}).build();
    private static final SdkField<ParquetConfiguration> PARQUET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parquetConfiguration").getter(FileFormatConfiguration.getter(FileFormatConfiguration::parquetConfiguration)).setter(FileFormatConfiguration.setter(Builder::parquetConfiguration)).constructor(ParquetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_CONFIGURATION_FIELD, PARQUET_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FileFormatConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final JsonConfiguration jsonConfiguration;
    private final ParquetConfiguration parquetConfiguration;

    private FileFormatConfiguration(BuilderImpl builder) {
        this.jsonConfiguration = builder.jsonConfiguration;
        this.parquetConfiguration = builder.parquetConfiguration;
    }

    public final JsonConfiguration jsonConfiguration() {
        return this.jsonConfiguration;
    }

    public final ParquetConfiguration parquetConfiguration() {
        return this.parquetConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.parquetConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileFormatConfiguration)) {
            return false;
        }
        FileFormatConfiguration other = (FileFormatConfiguration)obj;
        return Objects.equals(this.jsonConfiguration(), other.jsonConfiguration()) && Objects.equals(this.parquetConfiguration(), other.parquetConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"FileFormatConfiguration").add("JsonConfiguration", (Object)this.jsonConfiguration()).add("ParquetConfiguration", (Object)this.parquetConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jsonConfiguration": {
                return Optional.ofNullable(clazz.cast(this.jsonConfiguration()));
            }
            case "parquetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.parquetConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jsonConfiguration", JSON_CONFIGURATION_FIELD);
        map.put("parquetConfiguration", PARQUET_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileFormatConfiguration, T> g) {
        return obj -> g.apply((FileFormatConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JsonConfiguration jsonConfiguration;
        private ParquetConfiguration parquetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FileFormatConfiguration model) {
            this.jsonConfiguration(model.jsonConfiguration);
            this.parquetConfiguration(model.parquetConfiguration);
        }

        public final JsonConfiguration.Builder getJsonConfiguration() {
            return this.jsonConfiguration != null ? this.jsonConfiguration.toBuilder() : null;
        }

        public final void setJsonConfiguration(JsonConfiguration.BuilderImpl jsonConfiguration) {
            this.jsonConfiguration = jsonConfiguration != null ? jsonConfiguration.build() : null;
        }

        @Override
        public final Builder jsonConfiguration(JsonConfiguration jsonConfiguration) {
            this.jsonConfiguration = jsonConfiguration;
            return this;
        }

        public final ParquetConfiguration.Builder getParquetConfiguration() {
            return this.parquetConfiguration != null ? this.parquetConfiguration.toBuilder() : null;
        }

        public final void setParquetConfiguration(ParquetConfiguration.BuilderImpl parquetConfiguration) {
            this.parquetConfiguration = parquetConfiguration != null ? parquetConfiguration.build() : null;
        }

        @Override
        public final Builder parquetConfiguration(ParquetConfiguration parquetConfiguration) {
            this.parquetConfiguration = parquetConfiguration;
            return this;
        }

        public FileFormatConfiguration build() {
            return new FileFormatConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileFormatConfiguration> {
        public Builder jsonConfiguration(JsonConfiguration var1);

        default public Builder jsonConfiguration(Consumer<JsonConfiguration.Builder> jsonConfiguration) {
            return this.jsonConfiguration((JsonConfiguration)((JsonConfiguration.Builder)JsonConfiguration.builder().applyMutation(jsonConfiguration)).build());
        }

        public Builder parquetConfiguration(ParquetConfiguration var1);

        default public Builder parquetConfiguration(Consumer<ParquetConfiguration.Builder> parquetConfiguration) {
            return this.parquetConfiguration((ParquetConfiguration)((ParquetConfiguration.Builder)ParquetConfiguration.builder().applyMutation(parquetConfiguration)).build());
        }
    }
}

