/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.Channel;
import software.amazon.awssdk.services.iotanalytics.model.ChannelStatistics;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeChannelResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, DescribeChannelResponse> {
    private static final SdkField<Channel> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("channel").getter(DescribeChannelResponse.getter(DescribeChannelResponse::channel)).setter(DescribeChannelResponse.setter(Builder::channel)).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<ChannelStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statistics").getter(DescribeChannelResponse.getter(DescribeChannelResponse::statistics)).setter(DescribeChannelResponse.setter(Builder::statistics)).constructor(ChannelStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeChannelResponse.memberNameToFieldInitializer();
    private final Channel channel;
    private final ChannelStatistics statistics;

    private DescribeChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channel = builder.channel;
        this.statistics = builder.statistics;
    }

    public final Channel channel() {
        return this.channel;
    }

    public final ChannelStatistics statistics() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channel());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelResponse)) {
            return false;
        }
        DescribeChannelResponse other = (DescribeChannelResponse)((Object)obj);
        return Objects.equals(this.channel(), other.channel()) && Objects.equals(this.statistics(), other.statistics());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeChannelResponse").add("Channel", (Object)this.channel()).add("Statistics", (Object)this.statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channel", CHANNEL_FIELD);
        map.put("statistics", STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelResponse, T> g) {
        return obj -> g.apply((DescribeChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private Channel channel;
        private ChannelStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelResponse model) {
            super(model);
            this.channel(model.channel);
            this.statistics(model.statistics);
        }

        public final Channel.Builder getChannel() {
            return this.channel != null ? this.channel.toBuilder() : null;
        }

        public final void setChannel(Channel.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public final ChannelStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(ChannelStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(ChannelStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public DescribeChannelResponse build() {
            return new DescribeChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeChannelResponse> {
        public Builder channel(Channel var1);

        default public Builder channel(Consumer<Channel.Builder> channel) {
            return this.channel((Channel)((Channel.Builder)Channel.builder().applyMutation(channel)).build());
        }

        public Builder statistics(ChannelStatistics var1);

        default public Builder statistics(Consumer<ChannelStatistics.Builder> statistics) {
            return this.statistics((ChannelStatistics)((ChannelStatistics.Builder)ChannelStatistics.builder().applyMutation(statistics)).build());
        }
    }
}

