/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.CustomerManagedDatastoreS3StorageSummary;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary;
import software.amazon.awssdk.services.iotanalytics.model.ServiceManagedDatastoreS3StorageSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatastoreStorageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatastoreStorageSummary> {
    private static final SdkField<ServiceManagedDatastoreS3StorageSummary> SERVICE_MANAGED_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceManagedS3").getter(DatastoreStorageSummary.getter(DatastoreStorageSummary::serviceManagedS3)).setter(DatastoreStorageSummary.setter(Builder::serviceManagedS3)).constructor(ServiceManagedDatastoreS3StorageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedS3").build()}).build();
    private static final SdkField<CustomerManagedDatastoreS3StorageSummary> CUSTOMER_MANAGED_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerManagedS3").getter(DatastoreStorageSummary.getter(DatastoreStorageSummary::customerManagedS3)).setter(DatastoreStorageSummary.setter(Builder::customerManagedS3)).constructor(CustomerManagedDatastoreS3StorageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3").build()}).build();
    private static final SdkField<DatastoreIotSiteWiseMultiLayerStorageSummary> IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotSiteWiseMultiLayerStorage").getter(DatastoreStorageSummary.getter(DatastoreStorageSummary::iotSiteWiseMultiLayerStorage)).setter(DatastoreStorageSummary.setter(Builder::iotSiteWiseMultiLayerStorage)).constructor(DatastoreIotSiteWiseMultiLayerStorageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWiseMultiLayerStorage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_MANAGED_S3_FIELD, CUSTOMER_MANAGED_S3_FIELD, IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatastoreStorageSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ServiceManagedDatastoreS3StorageSummary serviceManagedS3;
    private final CustomerManagedDatastoreS3StorageSummary customerManagedS3;
    private final DatastoreIotSiteWiseMultiLayerStorageSummary iotSiteWiseMultiLayerStorage;

    private DatastoreStorageSummary(BuilderImpl builder) {
        this.serviceManagedS3 = builder.serviceManagedS3;
        this.customerManagedS3 = builder.customerManagedS3;
        this.iotSiteWiseMultiLayerStorage = builder.iotSiteWiseMultiLayerStorage;
    }

    public final ServiceManagedDatastoreS3StorageSummary serviceManagedS3() {
        return this.serviceManagedS3;
    }

    public final CustomerManagedDatastoreS3StorageSummary customerManagedS3() {
        return this.customerManagedS3;
    }

    public final DatastoreIotSiteWiseMultiLayerStorageSummary iotSiteWiseMultiLayerStorage() {
        return this.iotSiteWiseMultiLayerStorage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotSiteWiseMultiLayerStorage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreStorageSummary)) {
            return false;
        }
        DatastoreStorageSummary other = (DatastoreStorageSummary)obj;
        return Objects.equals(this.serviceManagedS3(), other.serviceManagedS3()) && Objects.equals(this.customerManagedS3(), other.customerManagedS3()) && Objects.equals(this.iotSiteWiseMultiLayerStorage(), other.iotSiteWiseMultiLayerStorage());
    }

    public final String toString() {
        return ToString.builder((String)"DatastoreStorageSummary").add("ServiceManagedS3", (Object)this.serviceManagedS3()).add("CustomerManagedS3", (Object)this.customerManagedS3()).add("IotSiteWiseMultiLayerStorage", (Object)this.iotSiteWiseMultiLayerStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceManagedS3": {
                return Optional.ofNullable(clazz.cast(this.serviceManagedS3()));
            }
            case "customerManagedS3": {
                return Optional.ofNullable(clazz.cast(this.customerManagedS3()));
            }
            case "iotSiteWiseMultiLayerStorage": {
                return Optional.ofNullable(clazz.cast(this.iotSiteWiseMultiLayerStorage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceManagedS3", SERVICE_MANAGED_S3_FIELD);
        map.put("customerManagedS3", CUSTOMER_MANAGED_S3_FIELD);
        map.put("iotSiteWiseMultiLayerStorage", IOT_SITE_WISE_MULTI_LAYER_STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatastoreStorageSummary, T> g) {
        return obj -> g.apply((DatastoreStorageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ServiceManagedDatastoreS3StorageSummary serviceManagedS3;
        private CustomerManagedDatastoreS3StorageSummary customerManagedS3;
        private DatastoreIotSiteWiseMultiLayerStorageSummary iotSiteWiseMultiLayerStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreStorageSummary model) {
            this.serviceManagedS3(model.serviceManagedS3);
            this.customerManagedS3(model.customerManagedS3);
            this.iotSiteWiseMultiLayerStorage(model.iotSiteWiseMultiLayerStorage);
        }

        public final ServiceManagedDatastoreS3StorageSummary.Builder getServiceManagedS3() {
            return this.serviceManagedS3 != null ? this.serviceManagedS3.toBuilder() : null;
        }

        public final void setServiceManagedS3(ServiceManagedDatastoreS3StorageSummary.BuilderImpl serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3 != null ? serviceManagedS3.build() : null;
        }

        @Override
        public final Builder serviceManagedS3(ServiceManagedDatastoreS3StorageSummary serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3;
            return this;
        }

        public final CustomerManagedDatastoreS3StorageSummary.Builder getCustomerManagedS3() {
            return this.customerManagedS3 != null ? this.customerManagedS3.toBuilder() : null;
        }

        public final void setCustomerManagedS3(CustomerManagedDatastoreS3StorageSummary.BuilderImpl customerManagedS3) {
            this.customerManagedS3 = customerManagedS3 != null ? customerManagedS3.build() : null;
        }

        @Override
        public final Builder customerManagedS3(CustomerManagedDatastoreS3StorageSummary customerManagedS3) {
            this.customerManagedS3 = customerManagedS3;
            return this;
        }

        public final DatastoreIotSiteWiseMultiLayerStorageSummary.Builder getIotSiteWiseMultiLayerStorage() {
            return this.iotSiteWiseMultiLayerStorage != null ? this.iotSiteWiseMultiLayerStorage.toBuilder() : null;
        }

        public final void setIotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorageSummary.BuilderImpl iotSiteWiseMultiLayerStorage) {
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage != null ? iotSiteWiseMultiLayerStorage.build() : null;
        }

        @Override
        public final Builder iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorageSummary iotSiteWiseMultiLayerStorage) {
            this.iotSiteWiseMultiLayerStorage = iotSiteWiseMultiLayerStorage;
            return this;
        }

        public DatastoreStorageSummary build() {
            return new DatastoreStorageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatastoreStorageSummary> {
        public Builder serviceManagedS3(ServiceManagedDatastoreS3StorageSummary var1);

        default public Builder serviceManagedS3(Consumer<ServiceManagedDatastoreS3StorageSummary.Builder> serviceManagedS3) {
            return this.serviceManagedS3((ServiceManagedDatastoreS3StorageSummary)((ServiceManagedDatastoreS3StorageSummary.Builder)ServiceManagedDatastoreS3StorageSummary.builder().applyMutation(serviceManagedS3)).build());
        }

        public Builder customerManagedS3(CustomerManagedDatastoreS3StorageSummary var1);

        default public Builder customerManagedS3(Consumer<CustomerManagedDatastoreS3StorageSummary.Builder> customerManagedS3) {
            return this.customerManagedS3((CustomerManagedDatastoreS3StorageSummary)((CustomerManagedDatastoreS3StorageSummary.Builder)CustomerManagedDatastoreS3StorageSummary.builder().applyMutation(customerManagedS3)).build());
        }

        public Builder iotSiteWiseMultiLayerStorage(DatastoreIotSiteWiseMultiLayerStorageSummary var1);

        default public Builder iotSiteWiseMultiLayerStorage(Consumer<DatastoreIotSiteWiseMultiLayerStorageSummary.Builder> iotSiteWiseMultiLayerStorage) {
            return this.iotSiteWiseMultiLayerStorage((DatastoreIotSiteWiseMultiLayerStorageSummary)((DatastoreIotSiteWiseMultiLayerStorageSummary.Builder)DatastoreIotSiteWiseMultiLayerStorageSummary.builder().applyMutation(iotSiteWiseMultiLayerStorage)).build());
        }
    }
}

