/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsAsyncClient;
import software.amazon.awssdk.services.iotanalytics.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotanalytics.model.ListDatastoresRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatastoresResponse;

public class ListDatastoresPublisher
implements SdkPublisher<ListDatastoresResponse> {
    private final IoTAnalyticsAsyncClient client;
    private final ListDatastoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatastoresPublisher(IoTAnalyticsAsyncClient client, ListDatastoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatastoresPublisher(IoTAnalyticsAsyncClient client, ListDatastoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatastoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatastoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDatastoresResponseFetcher
    implements AsyncPageFetcher<ListDatastoresResponse> {
        private ListDatastoresResponseFetcher() {
        }

        public boolean hasNextPage(ListDatastoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatastoresResponse> nextPage(ListDatastoresResponse previousPage) {
            if (previousPage == null) {
                return ListDatastoresPublisher.this.client.listDatastores(ListDatastoresPublisher.this.firstRequest);
            }
            return ListDatastoresPublisher.this.client.listDatastores((ListDatastoresRequest)((Object)ListDatastoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

