/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iot1clickprojects.endpoints.Iot1ClickProjectsEndpointParams;
import software.amazon.awssdk.services.iot1clickprojects.endpoints.Iot1ClickProjectsEndpointProvider;
import software.amazon.awssdk.services.iot1clickprojects.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.iot1clickprojects.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.iot1clickprojects.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIot1ClickProjectsEndpointProvider
implements Iot1ClickProjectsEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(Iot1ClickProjectsEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultIot1ClickProjectsEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        RuleResult result = DefaultIot1ClickProjectsEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultIot1ClickProjectsEndpointProvider.endpointRule5(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultIot1ClickProjectsEndpointProvider.endpointRule20(params, locals);
    }

    private static RuleResult endpointRule1(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultIot1ClickProjectsEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIot1ClickProjectsEndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIot1ClickProjectsEndpointProvider.endpointRule4(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule5(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultIot1ClickProjectsEndpointProvider.endpointRule6(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultIot1ClickProjectsEndpointProvider.endpointRule7(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIot1ClickProjectsEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIot1ClickProjectsEndpointProvider.endpointRule15(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIot1ClickProjectsEndpointProvider.endpointRule19(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIot1ClickProjectsEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIot1ClickProjectsEndpointProvider.endpointRule10(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultIot1ClickProjectsEndpointProvider.endpointRule9(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://projects.iot1click-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule10(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule11(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultIot1ClickProjectsEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIot1ClickProjectsEndpointProvider.endpointRule14(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultIot1ClickProjectsEndpointProvider.endpointRule13(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://projects.iot1click-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule14(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule15(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIot1ClickProjectsEndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIot1ClickProjectsEndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultIot1ClickProjectsEndpointProvider.endpointRule17(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://projects.iot1click." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule18(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule19(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://projects.iot1click." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule20(Iot1ClickProjectsEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

