/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickdevices.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot1clickdevices.model.Iot1ClickDevicesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceEventsRequest
extends Iot1ClickDevicesRequest
implements ToCopyableBuilder<Builder, ListDeviceEventsRequest> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDeviceEventsRequest.getter(ListDeviceEventsRequest::deviceId)).setter(ListDeviceEventsRequest.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("deviceId").build()}).build();
    private static final SdkField<Instant> FROM_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListDeviceEventsRequest.getter(ListDeviceEventsRequest::fromTimeStamp)).setter(ListDeviceEventsRequest.setter(Builder::fromTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fromTimeStamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListDeviceEventsRequest.getter(ListDeviceEventsRequest::maxResults)).setter(ListDeviceEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDeviceEventsRequest.getter(ListDeviceEventsRequest::nextToken)).setter(ListDeviceEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Instant> TO_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListDeviceEventsRequest.getter(ListDeviceEventsRequest::toTimeStamp)).setter(ListDeviceEventsRequest.setter(Builder::toTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("toTimeStamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, FROM_TIME_STAMP_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TO_TIME_STAMP_FIELD));
    private final String deviceId;
    private final Instant fromTimeStamp;
    private final Integer maxResults;
    private final String nextToken;
    private final Instant toTimeStamp;

    private ListDeviceEventsRequest(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.fromTimeStamp = builder.fromTimeStamp;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.toTimeStamp = builder.toTimeStamp;
    }

    public String deviceId() {
        return this.deviceId;
    }

    public Instant fromTimeStamp() {
        return this.fromTimeStamp;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Instant toTimeStamp() {
        return this.toTimeStamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.toTimeStamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceEventsRequest)) {
            return false;
        }
        ListDeviceEventsRequest other = (ListDeviceEventsRequest)((Object)obj);
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.fromTimeStamp(), other.fromTimeStamp()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.toTimeStamp(), other.toTimeStamp());
    }

    public String toString() {
        return ToString.builder((String)"ListDeviceEventsRequest").add("DeviceId", (Object)this.deviceId()).add("FromTimeStamp", (Object)this.fromTimeStamp()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ToTimeStamp", (Object)this.toTimeStamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "FromTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.fromTimeStamp()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ToTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.toTimeStamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceEventsRequest, T> g) {
        return obj -> g.apply((ListDeviceEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Iot1ClickDevicesRequest.BuilderImpl
    implements Builder {
        private String deviceId;
        private Instant fromTimeStamp;
        private Integer maxResults;
        private String nextToken;
        private Instant toTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceEventsRequest model) {
            super(model);
            this.deviceId(model.deviceId);
            this.fromTimeStamp(model.fromTimeStamp);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.toTimeStamp(model.toTimeStamp);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final Instant getFromTimeStamp() {
            return this.fromTimeStamp;
        }

        @Override
        public final Builder fromTimeStamp(Instant fromTimeStamp) {
            this.fromTimeStamp = fromTimeStamp;
            return this;
        }

        public final void setFromTimeStamp(Instant fromTimeStamp) {
            this.fromTimeStamp = fromTimeStamp;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Instant getToTimeStamp() {
            return this.toTimeStamp;
        }

        @Override
        public final Builder toTimeStamp(Instant toTimeStamp) {
            this.toTimeStamp = toTimeStamp;
            return this;
        }

        public final void setToTimeStamp(Instant toTimeStamp) {
            this.toTimeStamp = toTimeStamp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeviceEventsRequest build() {
            return new ListDeviceEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Iot1ClickDevicesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeviceEventsRequest> {
        public Builder deviceId(String var1);

        public Builder fromTimeStamp(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder toTimeStamp(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

