/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ThingGroupProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDynamicThingGroupRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateDynamicThingGroupRequest> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDynamicThingGroupRequest.getter(UpdateDynamicThingGroupRequest::thingGroupName)).setter(UpdateDynamicThingGroupRequest.setter(Builder::thingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingGroupName").build()}).build();
    private static final SdkField<ThingGroupProperties> THING_GROUP_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDynamicThingGroupRequest.getter(UpdateDynamicThingGroupRequest::thingGroupProperties)).setter(UpdateDynamicThingGroupRequest.setter(Builder::thingGroupProperties)).constructor(ThingGroupProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupProperties").build()}).build();
    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(UpdateDynamicThingGroupRequest.getter(UpdateDynamicThingGroupRequest::expectedVersion)).setter(UpdateDynamicThingGroupRequest.setter(Builder::expectedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDynamicThingGroupRequest.getter(UpdateDynamicThingGroupRequest::indexName)).setter(UpdateDynamicThingGroupRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDynamicThingGroupRequest.getter(UpdateDynamicThingGroupRequest::queryString)).setter(UpdateDynamicThingGroupRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDynamicThingGroupRequest.getter(UpdateDynamicThingGroupRequest::queryVersion)).setter(UpdateDynamicThingGroupRequest.setter(Builder::queryVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD, THING_GROUP_PROPERTIES_FIELD, EXPECTED_VERSION_FIELD, INDEX_NAME_FIELD, QUERY_STRING_FIELD, QUERY_VERSION_FIELD));
    private final String thingGroupName;
    private final ThingGroupProperties thingGroupProperties;
    private final Long expectedVersion;
    private final String indexName;
    private final String queryString;
    private final String queryVersion;

    private UpdateDynamicThingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupProperties = builder.thingGroupProperties;
        this.expectedVersion = builder.expectedVersion;
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.queryVersion = builder.queryVersion;
    }

    public String thingGroupName() {
        return this.thingGroupName;
    }

    public ThingGroupProperties thingGroupProperties() {
        return this.thingGroupProperties;
    }

    public Long expectedVersion() {
        return this.expectedVersion;
    }

    public String indexName() {
        return this.indexName;
    }

    public String queryString() {
        return this.queryString;
    }

    public String queryVersion() {
        return this.queryVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDynamicThingGroupRequest)) {
            return false;
        }
        UpdateDynamicThingGroupRequest other = (UpdateDynamicThingGroupRequest)((Object)obj);
        return Objects.equals(this.thingGroupName(), other.thingGroupName()) && Objects.equals(this.thingGroupProperties(), other.thingGroupProperties()) && Objects.equals(this.expectedVersion(), other.expectedVersion()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.queryVersion(), other.queryVersion());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDynamicThingGroupRequest").add("ThingGroupName", (Object)this.thingGroupName()).add("ThingGroupProperties", (Object)this.thingGroupProperties()).add("ExpectedVersion", (Object)this.expectedVersion()).add("IndexName", (Object)this.indexName()).add("QueryString", (Object)this.queryString()).add("QueryVersion", (Object)this.queryVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroupName": {
                return Optional.ofNullable(clazz.cast(this.thingGroupName()));
            }
            case "thingGroupProperties": {
                return Optional.ofNullable(clazz.cast(this.thingGroupProperties()));
            }
            case "expectedVersion": {
                return Optional.ofNullable(clazz.cast(this.expectedVersion()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "queryVersion": {
                return Optional.ofNullable(clazz.cast(this.queryVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDynamicThingGroupRequest, T> g) {
        return obj -> g.apply((UpdateDynamicThingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingGroupName;
        private ThingGroupProperties thingGroupProperties;
        private Long expectedVersion;
        private String indexName;
        private String queryString;
        private String queryVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDynamicThingGroupRequest model) {
            super(model);
            this.thingGroupName(model.thingGroupName);
            this.thingGroupProperties(model.thingGroupProperties);
            this.expectedVersion(model.expectedVersion);
            this.indexName(model.indexName);
            this.queryString(model.queryString);
            this.queryVersion(model.queryVersion);
        }

        public final String getThingGroupName() {
            return this.thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return this.thingGroupProperties != null ? this.thingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        public final Long getExpectedVersion() {
            return this.expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getQueryVersion() {
            return this.queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDynamicThingGroupRequest build() {
            return new UpdateDynamicThingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDynamicThingGroupRequest> {
        public Builder thingGroupName(String var1);

        public Builder thingGroupProperties(ThingGroupProperties var1);

        default public Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return this.thingGroupProperties((ThingGroupProperties)((ThingGroupProperties.Builder)ThingGroupProperties.builder().applyMutation(thingGroupProperties)).build());
        }

        public Builder expectedVersion(Long var1);

        public Builder indexName(String var1);

        public Builder queryString(String var1);

        public Builder queryVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

