/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuditCheckToReasonCodeFilterCopier;
import software.amazon.awssdk.services.iot.model.FindingIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditMitigationActionsTaskTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditMitigationActionsTaskTarget> {
    private static final SdkField<String> AUDIT_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuditMitigationActionsTaskTarget.getter(AuditMitigationActionsTaskTarget::auditTaskId)).setter(AuditMitigationActionsTaskTarget.setter(Builder::auditTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditTaskId").build()}).build();
    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AuditMitigationActionsTaskTarget.getter(AuditMitigationActionsTaskTarget::findingIds)).setter(AuditMitigationActionsTaskTarget.setter(Builder::findingIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> AUDIT_CHECK_TO_REASON_CODE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AuditMitigationActionsTaskTarget.getter(AuditMitigationActionsTaskTarget::auditCheckToReasonCodeFilter)).setter(AuditMitigationActionsTaskTarget.setter(Builder::auditCheckToReasonCodeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditCheckToReasonCodeFilter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_TASK_ID_FIELD, FINDING_IDS_FIELD, AUDIT_CHECK_TO_REASON_CODE_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String auditTaskId;
    private final List<String> findingIds;
    private final Map<String, List<String>> auditCheckToReasonCodeFilter;

    private AuditMitigationActionsTaskTarget(BuilderImpl builder) {
        this.auditTaskId = builder.auditTaskId;
        this.findingIds = builder.findingIds;
        this.auditCheckToReasonCodeFilter = builder.auditCheckToReasonCodeFilter;
    }

    public String auditTaskId() {
        return this.auditTaskId;
    }

    public List<String> findingIds() {
        return this.findingIds;
    }

    public Map<String, List<String>> auditCheckToReasonCodeFilter() {
        return this.auditCheckToReasonCodeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.auditTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditCheckToReasonCodeFilter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditMitigationActionsTaskTarget)) {
            return false;
        }
        AuditMitigationActionsTaskTarget other = (AuditMitigationActionsTaskTarget)obj;
        return Objects.equals(this.auditTaskId(), other.auditTaskId()) && Objects.equals(this.findingIds(), other.findingIds()) && Objects.equals(this.auditCheckToReasonCodeFilter(), other.auditCheckToReasonCodeFilter());
    }

    public String toString() {
        return ToString.builder((String)"AuditMitigationActionsTaskTarget").add("AuditTaskId", (Object)this.auditTaskId()).add("FindingIds", this.findingIds()).add("AuditCheckToReasonCodeFilter", this.auditCheckToReasonCodeFilter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "auditTaskId": {
                return Optional.ofNullable(clazz.cast(this.auditTaskId()));
            }
            case "findingIds": {
                return Optional.ofNullable(clazz.cast(this.findingIds()));
            }
            case "auditCheckToReasonCodeFilter": {
                return Optional.ofNullable(clazz.cast(this.auditCheckToReasonCodeFilter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditMitigationActionsTaskTarget, T> g) {
        return obj -> g.apply((AuditMitigationActionsTaskTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String auditTaskId;
        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> auditCheckToReasonCodeFilter = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuditMitigationActionsTaskTarget model) {
            this.auditTaskId(model.auditTaskId);
            this.findingIds(model.findingIds);
            this.auditCheckToReasonCodeFilter(model.auditCheckToReasonCodeFilter);
        }

        public final String getAuditTaskId() {
            return this.auditTaskId;
        }

        @Override
        public final Builder auditTaskId(String auditTaskId) {
            this.auditTaskId = auditTaskId;
            return this;
        }

        public final void setAuditTaskId(String auditTaskId) {
            this.auditTaskId = auditTaskId;
        }

        public final Collection<String> getFindingIds() {
            return this.findingIds;
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String ... findingIds) {
            this.findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
        }

        public final Map<String, ? extends Collection<String>> getAuditCheckToReasonCodeFilter() {
            return this.auditCheckToReasonCodeFilter;
        }

        @Override
        public final Builder auditCheckToReasonCodeFilter(Map<String, ? extends Collection<String>> auditCheckToReasonCodeFilter) {
            this.auditCheckToReasonCodeFilter = AuditCheckToReasonCodeFilterCopier.copy(auditCheckToReasonCodeFilter);
            return this;
        }

        public final void setAuditCheckToReasonCodeFilter(Map<String, ? extends Collection<String>> auditCheckToReasonCodeFilter) {
            this.auditCheckToReasonCodeFilter = AuditCheckToReasonCodeFilterCopier.copy(auditCheckToReasonCodeFilter);
        }

        public AuditMitigationActionsTaskTarget build() {
            return new AuditMitigationActionsTaskTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditMitigationActionsTaskTarget> {
        public Builder auditTaskId(String var1);

        public Builder findingIds(Collection<String> var1);

        public Builder findingIds(String ... var1);

        public Builder auditCheckToReasonCodeFilter(Map<String, ? extends Collection<String>> var1);
    }
}

