/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.Action;
import software.amazon.awssdk.services.iot.model.ActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRulePayload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicRulePayload> {
    private static final SdkField<String> SQL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicRulePayload.getter(TopicRulePayload::sql)).setter(TopicRulePayload.setter(Builder::sql)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sql").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicRulePayload.getter(TopicRulePayload::description)).setter(TopicRulePayload.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TopicRulePayload.getter(TopicRulePayload::actions)).setter(TopicRulePayload.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> RULE_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(TopicRulePayload.getter(TopicRulePayload::ruleDisabled)).setter(TopicRulePayload.setter(Builder::ruleDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDisabled").build()}).build();
    private static final SdkField<String> AWS_IOT_SQL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TopicRulePayload.getter(TopicRulePayload::awsIotSqlVersion)).setter(TopicRulePayload.setter(Builder::awsIotSqlVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotSqlVersion").build()}).build();
    private static final SdkField<Action> ERROR_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TopicRulePayload.getter(TopicRulePayload::errorAction)).setter(TopicRulePayload.setter(Builder::errorAction)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_FIELD, DESCRIPTION_FIELD, ACTIONS_FIELD, RULE_DISABLED_FIELD, AWS_IOT_SQL_VERSION_FIELD, ERROR_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sql;
    private final String description;
    private final List<Action> actions;
    private final Boolean ruleDisabled;
    private final String awsIotSqlVersion;
    private final Action errorAction;

    private TopicRulePayload(BuilderImpl builder) {
        this.sql = builder.sql;
        this.description = builder.description;
        this.actions = builder.actions;
        this.ruleDisabled = builder.ruleDisabled;
        this.awsIotSqlVersion = builder.awsIotSqlVersion;
        this.errorAction = builder.errorAction;
    }

    public String sql() {
        return this.sql;
    }

    public String description() {
        return this.description;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public Boolean ruleDisabled() {
        return this.ruleDisabled;
    }

    public String awsIotSqlVersion() {
        return this.awsIotSqlVersion;
    }

    public Action errorAction() {
        return this.errorAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sql());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotSqlVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRulePayload)) {
            return false;
        }
        TopicRulePayload other = (TopicRulePayload)obj;
        return Objects.equals(this.sql(), other.sql()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.ruleDisabled(), other.ruleDisabled()) && Objects.equals(this.awsIotSqlVersion(), other.awsIotSqlVersion()) && Objects.equals(this.errorAction(), other.errorAction());
    }

    public String toString() {
        return ToString.builder((String)"TopicRulePayload").add("Sql", (Object)this.sql()).add("Description", (Object)this.description()).add("Actions", this.actions()).add("RuleDisabled", (Object)this.ruleDisabled()).add("AwsIotSqlVersion", (Object)this.awsIotSqlVersion()).add("ErrorAction", (Object)this.errorAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sql": {
                return Optional.ofNullable(clazz.cast(this.sql()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "ruleDisabled": {
                return Optional.ofNullable(clazz.cast(this.ruleDisabled()));
            }
            case "awsIotSqlVersion": {
                return Optional.ofNullable(clazz.cast(this.awsIotSqlVersion()));
            }
            case "errorAction": {
                return Optional.ofNullable(clazz.cast(this.errorAction()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRulePayload, T> g) {
        return obj -> g.apply((TopicRulePayload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sql;
        private String description;
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();
        private Boolean ruleDisabled;
        private String awsIotSqlVersion;
        private Action errorAction;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRulePayload model) {
            this.sql(model.sql);
            this.description(model.description);
            this.actions(model.actions);
            this.ruleDisabled(model.ruleDisabled);
            this.awsIotSqlVersion(model.awsIotSqlVersion);
            this.errorAction(model.errorAction);
        }

        public final String getSql() {
            return this.sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Action.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        public final Boolean getRuleDisabled() {
            return this.ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        public final String getAwsIotSqlVersion() {
            return this.awsIotSqlVersion;
        }

        @Override
        public final Builder awsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
            return this;
        }

        public final void setAwsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
        }

        public final Action.Builder getErrorAction() {
            return this.errorAction != null ? this.errorAction.toBuilder() : null;
        }

        @Override
        public final Builder errorAction(Action errorAction) {
            this.errorAction = errorAction;
            return this;
        }

        public final void setErrorAction(Action.BuilderImpl errorAction) {
            this.errorAction = errorAction != null ? errorAction.build() : null;
        }

        public TopicRulePayload build() {
            return new TopicRulePayload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicRulePayload> {
        public Builder sql(String var1);

        public Builder description(String var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);

        public Builder ruleDisabled(Boolean var1);

        public Builder awsIotSqlVersion(String var1);

        public Builder errorAction(Action var1);

        default public Builder errorAction(Consumer<Action.Builder> errorAction) {
            return this.errorAction((Action)((Action.Builder)Action.builder().applyMutation(errorAction)).build());
        }
    }
}

