/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuditFrequency;
import software.amazon.awssdk.services.iot.model.DayOfWeek;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.services.iot.model.TargetAuditCheckNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScheduledAuditRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateScheduledAuditRequest> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateScheduledAuditRequest.getter(CreateScheduledAuditRequest::frequencyAsString)).setter(CreateScheduledAuditRequest.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<String> DAY_OF_MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateScheduledAuditRequest.getter(CreateScheduledAuditRequest::dayOfMonth)).setter(CreateScheduledAuditRequest.setter(Builder::dayOfMonth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfMonth").build()}).build();
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateScheduledAuditRequest.getter(CreateScheduledAuditRequest::dayOfWeekAsString)).setter(CreateScheduledAuditRequest.setter(Builder::dayOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfWeek").build()}).build();
    private static final SdkField<List<String>> TARGET_CHECK_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateScheduledAuditRequest.getter(CreateScheduledAuditRequest::targetCheckNames)).setter(CreateScheduledAuditRequest.setter(Builder::targetCheckNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCheckNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateScheduledAuditRequest.getter(CreateScheduledAuditRequest::tags)).setter(CreateScheduledAuditRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULED_AUDIT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateScheduledAuditRequest.getter(CreateScheduledAuditRequest::scheduledAuditName)).setter(CreateScheduledAuditRequest.setter(Builder::scheduledAuditName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("scheduledAuditName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD, DAY_OF_MONTH_FIELD, DAY_OF_WEEK_FIELD, TARGET_CHECK_NAMES_FIELD, TAGS_FIELD, SCHEDULED_AUDIT_NAME_FIELD));
    private final String frequency;
    private final String dayOfMonth;
    private final String dayOfWeek;
    private final List<String> targetCheckNames;
    private final List<Tag> tags;
    private final String scheduledAuditName;

    private CreateScheduledAuditRequest(BuilderImpl builder) {
        super(builder);
        this.frequency = builder.frequency;
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
        this.targetCheckNames = builder.targetCheckNames;
        this.tags = builder.tags;
        this.scheduledAuditName = builder.scheduledAuditName;
    }

    public AuditFrequency frequency() {
        return AuditFrequency.fromValue(this.frequency);
    }

    public String frequencyAsString() {
        return this.frequency;
    }

    public String dayOfMonth() {
        return this.dayOfMonth;
    }

    public DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(this.dayOfWeek);
    }

    public String dayOfWeekAsString() {
        return this.dayOfWeek;
    }

    public List<String> targetCheckNames() {
        return this.targetCheckNames;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String scheduledAuditName() {
        return this.scheduledAuditName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCheckNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledAuditName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledAuditRequest)) {
            return false;
        }
        CreateScheduledAuditRequest other = (CreateScheduledAuditRequest)((Object)obj);
        return Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.dayOfMonth(), other.dayOfMonth()) && Objects.equals(this.dayOfWeekAsString(), other.dayOfWeekAsString()) && Objects.equals(this.targetCheckNames(), other.targetCheckNames()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.scheduledAuditName(), other.scheduledAuditName());
    }

    public String toString() {
        return ToString.builder((String)"CreateScheduledAuditRequest").add("Frequency", (Object)this.frequencyAsString()).add("DayOfMonth", (Object)this.dayOfMonth()).add("DayOfWeek", (Object)this.dayOfWeekAsString()).add("TargetCheckNames", this.targetCheckNames()).add("Tags", this.tags()).add("ScheduledAuditName", (Object)this.scheduledAuditName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "dayOfMonth": {
                return Optional.ofNullable(clazz.cast(this.dayOfMonth()));
            }
            case "dayOfWeek": {
                return Optional.ofNullable(clazz.cast(this.dayOfWeekAsString()));
            }
            case "targetCheckNames": {
                return Optional.ofNullable(clazz.cast(this.targetCheckNames()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "scheduledAuditName": {
                return Optional.ofNullable(clazz.cast(this.scheduledAuditName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledAuditRequest, T> g) {
        return obj -> g.apply((CreateScheduledAuditRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String frequency;
        private String dayOfMonth;
        private String dayOfWeek;
        private List<String> targetCheckNames = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String scheduledAuditName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledAuditRequest model) {
            super(model);
            this.frequency(model.frequency);
            this.dayOfMonth(model.dayOfMonth);
            this.dayOfWeek(model.dayOfWeek);
            this.targetCheckNames(model.targetCheckNames);
            this.tags(model.tags);
            this.scheduledAuditName(model.scheduledAuditName);
        }

        public final String getFrequencyAsString() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AuditFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final String getDayOfMonth() {
            return this.dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        public final String getDayOfWeekAsString() {
            return this.dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek.toString());
            return this;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public final Collection<String> getTargetCheckNames() {
            return this.targetCheckNames;
        }

        @Override
        public final Builder targetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetCheckNames(String ... targetCheckNames) {
            this.targetCheckNames(Arrays.asList(targetCheckNames));
            return this;
        }

        public final void setTargetCheckNames(Collection<String> targetCheckNames) {
            this.targetCheckNames = TargetAuditCheckNamesCopier.copy(targetCheckNames);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getScheduledAuditName() {
            return this.scheduledAuditName;
        }

        @Override
        public final Builder scheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
            return this;
        }

        public final void setScheduledAuditName(String scheduledAuditName) {
            this.scheduledAuditName = scheduledAuditName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduledAuditRequest build() {
            return new CreateScheduledAuditRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScheduledAuditRequest> {
        public Builder frequency(String var1);

        public Builder frequency(AuditFrequency var1);

        public Builder dayOfMonth(String var1);

        public Builder dayOfWeek(String var1);

        public Builder dayOfWeek(DayOfWeek var1);

        public Builder targetCheckNames(Collection<String> var1);

        public Builder targetCheckNames(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder scheduledAuditName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

