/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingConnectivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingConnectivity> {
    private static final SdkField<Boolean> CONNECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ThingConnectivity.getter(ThingConnectivity::connected)).setter(ThingConnectivity.setter(Builder::connected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connected").build()}).build();
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ThingConnectivity.getter(ThingConnectivity::timestamp)).setter(ThingConnectivity.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTED_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean connected;
    private final Long timestamp;

    private ThingConnectivity(BuilderImpl builder) {
        this.connected = builder.connected;
        this.timestamp = builder.timestamp;
    }

    public Boolean connected() {
        return this.connected;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connected());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingConnectivity)) {
            return false;
        }
        ThingConnectivity other = (ThingConnectivity)obj;
        return Objects.equals(this.connected(), other.connected()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"ThingConnectivity").add("Connected", (Object)this.connected()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connected": {
                return Optional.ofNullable(clazz.cast(this.connected()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingConnectivity, T> g) {
        return obj -> g.apply((ThingConnectivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean connected;
        private Long timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingConnectivity model) {
            this.connected(model.connected);
            this.timestamp(model.timestamp);
        }

        public final Boolean getConnected() {
            return this.connected;
        }

        @Override
        public final Builder connected(Boolean connected) {
            this.connected = connected;
            return this;
        }

        public final void setConnected(Boolean connected) {
            this.connected = connected;
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public ThingConnectivity build() {
            return new ThingConnectivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingConnectivity> {
        public Builder connected(Boolean var1);

        public Builder timestamp(Long var1);
    }
}

