/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTopicRulesRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ListTopicRulesRequest> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTopicRulesRequest.getter(ListTopicRulesRequest::topic)).setter(ListTopicRulesRequest.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("topic").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListTopicRulesRequest.getter(ListTopicRulesRequest::maxResults)).setter(ListTopicRulesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTopicRulesRequest.getter(ListTopicRulesRequest::nextToken)).setter(ListTopicRulesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Boolean> RULE_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListTopicRulesRequest.getter(ListTopicRulesRequest::ruleDisabled)).setter(ListTopicRulesRequest.setter(Builder::ruleDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ruleDisabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, RULE_DISABLED_FIELD));
    private final String topic;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean ruleDisabled;

    private ListTopicRulesRequest(BuilderImpl builder) {
        super(builder);
        this.topic = builder.topic;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ruleDisabled = builder.ruleDisabled;
    }

    public String topic() {
        return this.topic;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Boolean ruleDisabled() {
        return this.ruleDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleDisabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicRulesRequest)) {
            return false;
        }
        ListTopicRulesRequest other = (ListTopicRulesRequest)((Object)obj);
        return Objects.equals(this.topic(), other.topic()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.ruleDisabled(), other.ruleDisabled());
    }

    public String toString() {
        return ToString.builder((String)"ListTopicRulesRequest").add("Topic", (Object)this.topic()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("RuleDisabled", (Object)this.ruleDisabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ruleDisabled": {
                return Optional.ofNullable(clazz.cast(this.ruleDisabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTopicRulesRequest, T> g) {
        return obj -> g.apply((ListTopicRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String topic;
        private Integer maxResults;
        private String nextToken;
        private Boolean ruleDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicRulesRequest model) {
            super(model);
            this.topic(model.topic);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.ruleDisabled(model.ruleDisabled);
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getRuleDisabled() {
            return this.ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTopicRulesRequest build() {
            return new ListTopicRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTopicRulesRequest> {
        public Builder topic(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder ruleDisabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

