/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.Allowed;
import software.amazon.awssdk.services.iot.model.AuthDecision;
import software.amazon.awssdk.services.iot.model.AuthInfo;
import software.amazon.awssdk.services.iot.model.Denied;
import software.amazon.awssdk.services.iot.model.MissingContextValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthResult> {
    private static final SdkField<AuthInfo> AUTH_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AuthResult.getter(AuthResult::authInfo)).setter(AuthResult.setter(Builder::authInfo)).constructor(AuthInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authInfo").build()}).build();
    private static final SdkField<Allowed> ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AuthResult.getter(AuthResult::allowed)).setter(AuthResult.setter(Builder::allowed)).constructor(Allowed::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowed").build()}).build();
    private static final SdkField<Denied> DENIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AuthResult.getter(AuthResult::denied)).setter(AuthResult.setter(Builder::denied)).constructor(Denied::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denied").build()}).build();
    private static final SdkField<String> AUTH_DECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthResult.getter(AuthResult::authDecisionAsString)).setter(AuthResult.setter(Builder::authDecision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authDecision").build()}).build();
    private static final SdkField<List<String>> MISSING_CONTEXT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AuthResult.getter(AuthResult::missingContextValues)).setter(AuthResult.setter(Builder::missingContextValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingContextValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_INFO_FIELD, ALLOWED_FIELD, DENIED_FIELD, AUTH_DECISION_FIELD, MISSING_CONTEXT_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final AuthInfo authInfo;
    private final Allowed allowed;
    private final Denied denied;
    private final String authDecision;
    private final List<String> missingContextValues;

    private AuthResult(BuilderImpl builder) {
        this.authInfo = builder.authInfo;
        this.allowed = builder.allowed;
        this.denied = builder.denied;
        this.authDecision = builder.authDecision;
        this.missingContextValues = builder.missingContextValues;
    }

    public AuthInfo authInfo() {
        return this.authInfo;
    }

    public Allowed allowed() {
        return this.allowed;
    }

    public Denied denied() {
        return this.denied;
    }

    public AuthDecision authDecision() {
        return AuthDecision.fromValue(this.authDecision);
    }

    public String authDecisionAsString() {
        return this.authDecision;
    }

    public List<String> missingContextValues() {
        return this.missingContextValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowed());
        hashCode = 31 * hashCode + Objects.hashCode(this.denied());
        hashCode = 31 * hashCode + Objects.hashCode(this.authDecisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingContextValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthResult)) {
            return false;
        }
        AuthResult other = (AuthResult)obj;
        return Objects.equals(this.authInfo(), other.authInfo()) && Objects.equals(this.allowed(), other.allowed()) && Objects.equals(this.denied(), other.denied()) && Objects.equals(this.authDecisionAsString(), other.authDecisionAsString()) && Objects.equals(this.missingContextValues(), other.missingContextValues());
    }

    public String toString() {
        return ToString.builder((String)"AuthResult").add("AuthInfo", (Object)this.authInfo()).add("Allowed", (Object)this.allowed()).add("Denied", (Object)this.denied()).add("AuthDecision", (Object)this.authDecisionAsString()).add("MissingContextValues", this.missingContextValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authInfo": {
                return Optional.ofNullable(clazz.cast(this.authInfo()));
            }
            case "allowed": {
                return Optional.ofNullable(clazz.cast(this.allowed()));
            }
            case "denied": {
                return Optional.ofNullable(clazz.cast(this.denied()));
            }
            case "authDecision": {
                return Optional.ofNullable(clazz.cast(this.authDecisionAsString()));
            }
            case "missingContextValues": {
                return Optional.ofNullable(clazz.cast(this.missingContextValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthResult, T> g) {
        return obj -> g.apply((AuthResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AuthInfo authInfo;
        private Allowed allowed;
        private Denied denied;
        private String authDecision;
        private List<String> missingContextValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthResult model) {
            this.authInfo(model.authInfo);
            this.allowed(model.allowed);
            this.denied(model.denied);
            this.authDecision(model.authDecision);
            this.missingContextValues(model.missingContextValues);
        }

        public final AuthInfo.Builder getAuthInfo() {
            return this.authInfo != null ? this.authInfo.toBuilder() : null;
        }

        @Override
        public final Builder authInfo(AuthInfo authInfo) {
            this.authInfo = authInfo;
            return this;
        }

        public final void setAuthInfo(AuthInfo.BuilderImpl authInfo) {
            this.authInfo = authInfo != null ? authInfo.build() : null;
        }

        public final Allowed.Builder getAllowed() {
            return this.allowed != null ? this.allowed.toBuilder() : null;
        }

        @Override
        public final Builder allowed(Allowed allowed) {
            this.allowed = allowed;
            return this;
        }

        public final void setAllowed(Allowed.BuilderImpl allowed) {
            this.allowed = allowed != null ? allowed.build() : null;
        }

        public final Denied.Builder getDenied() {
            return this.denied != null ? this.denied.toBuilder() : null;
        }

        @Override
        public final Builder denied(Denied denied) {
            this.denied = denied;
            return this;
        }

        public final void setDenied(Denied.BuilderImpl denied) {
            this.denied = denied != null ? denied.build() : null;
        }

        public final String getAuthDecisionAsString() {
            return this.authDecision;
        }

        @Override
        public final Builder authDecision(String authDecision) {
            this.authDecision = authDecision;
            return this;
        }

        @Override
        public final Builder authDecision(AuthDecision authDecision) {
            this.authDecision(authDecision.toString());
            return this;
        }

        public final void setAuthDecision(String authDecision) {
            this.authDecision = authDecision;
        }

        public final Collection<String> getMissingContextValues() {
            return this.missingContextValues;
        }

        @Override
        public final Builder missingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = MissingContextValuesCopier.copy(missingContextValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingContextValues(String ... missingContextValues) {
            this.missingContextValues(Arrays.asList(missingContextValues));
            return this;
        }

        public final void setMissingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = MissingContextValuesCopier.copy(missingContextValues);
        }

        public AuthResult build() {
            return new AuthResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthResult> {
        public Builder authInfo(AuthInfo var1);

        default public Builder authInfo(Consumer<AuthInfo.Builder> authInfo) {
            return this.authInfo((AuthInfo)((AuthInfo.Builder)AuthInfo.builder().applyMutation(authInfo)).build());
        }

        public Builder allowed(Allowed var1);

        default public Builder allowed(Consumer<Allowed.Builder> allowed) {
            return this.allowed((Allowed)((Allowed.Builder)Allowed.builder().applyMutation(allowed)).build());
        }

        public Builder denied(Denied var1);

        default public Builder denied(Consumer<Denied.Builder> denied) {
            return this.denied((Denied)((Denied.Builder)Denied.builder().applyMutation(denied)).build());
        }

        public Builder authDecision(String var1);

        public Builder authDecision(AuthDecision var1);

        public Builder missingContextValues(Collection<String> var1);

        public Builder missingContextValues(String ... var1);
    }
}

