/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.PoliciesCopier;
import software.amazon.awssdk.services.iot.model.Policy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImplicitDeny
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImplicitDeny> {
    private static final SdkField<List<Policy>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ImplicitDeny.getter(ImplicitDeny::policies)).setter(ImplicitDeny.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Policy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Policy> policies;

    private ImplicitDeny(BuilderImpl builder) {
        this.policies = builder.policies;
    }

    public List<Policy> policies() {
        return this.policies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImplicitDeny)) {
            return false;
        }
        ImplicitDeny other = (ImplicitDeny)obj;
        return Objects.equals(this.policies(), other.policies());
    }

    public String toString() {
        return ToString.builder((String)"ImplicitDeny").add("Policies", this.policies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImplicitDeny, T> g) {
        return obj -> g.apply((ImplicitDeny)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Policy> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImplicitDeny model) {
            this.policies(model.policies);
        }

        public final Collection<Policy.Builder> getPolicies() {
            return this.policies != null ? (Collection)this.policies.stream().map(Policy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policies(Collection<Policy> policies) {
            this.policies = PoliciesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Policy ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<Policy.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (Policy)((Policy.Builder)Policy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicies(Collection<Policy.BuilderImpl> policies) {
            this.policies = PoliciesCopier.copyFromBuilder(policies);
        }

        public ImplicitDeny build() {
            return new ImplicitDeny(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImplicitDeny> {
        public Builder policies(Collection<Policy> var1);

        public Builder policies(Policy ... var1);

        public Builder policies(Consumer<Policy.Builder> ... var1);
    }
}

