/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyPair
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyPair> {
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyPair.getter(KeyPair::publicKey)).setter(KeyPair.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyPair.getter(KeyPair::privateKey)).setter(KeyPair.setter(Builder::privateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_FIELD, PRIVATE_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String publicKey;
    private final String privateKey;

    private KeyPair(BuilderImpl builder) {
        this.publicKey = builder.publicKey;
        this.privateKey = builder.privateKey;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair)obj;
        return Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.privateKey(), other.privateKey());
    }

    public String toString() {
        return ToString.builder((String)"KeyPair").add("PublicKey", (Object)this.publicKey()).add("PrivateKey", (Object)(this.privateKey() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyPair, T> g) {
        return obj -> g.apply((KeyPair)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String publicKey;
        private String privateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPair model) {
            this.publicKey(model.publicKey);
            this.privateKey(model.privateKey);
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public KeyPair build() {
            return new KeyPair(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyPair> {
        public Builder publicKey(String var1);

        public Builder privateKey(String var1);
    }
}

