/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.DynamoKeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamoDBAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamoDBAction> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::tableName)).setter(DynamoDBAction.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::roleArn)).setter(DynamoDBAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::operation)).setter(DynamoDBAction.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<String> HASH_KEY_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::hashKeyField)).setter(DynamoDBAction.setter(Builder::hashKeyField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashKeyField").build()}).build();
    private static final SdkField<String> HASH_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::hashKeyValue)).setter(DynamoDBAction.setter(Builder::hashKeyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashKeyValue").build()}).build();
    private static final SdkField<String> HASH_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::hashKeyTypeAsString)).setter(DynamoDBAction.setter(Builder::hashKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashKeyType").build()}).build();
    private static final SdkField<String> RANGE_KEY_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::rangeKeyField)).setter(DynamoDBAction.setter(Builder::rangeKeyField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rangeKeyField").build()}).build();
    private static final SdkField<String> RANGE_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::rangeKeyValue)).setter(DynamoDBAction.setter(Builder::rangeKeyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rangeKeyValue").build()}).build();
    private static final SdkField<String> RANGE_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::rangeKeyTypeAsString)).setter(DynamoDBAction.setter(Builder::rangeKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rangeKeyType").build()}).build();
    private static final SdkField<String> PAYLOAD_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::payloadField)).setter(DynamoDBAction.setter(Builder::payloadField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, ROLE_ARN_FIELD, OPERATION_FIELD, HASH_KEY_FIELD_FIELD, HASH_KEY_VALUE_FIELD, HASH_KEY_TYPE_FIELD, RANGE_KEY_FIELD_FIELD, RANGE_KEY_VALUE_FIELD, RANGE_KEY_TYPE_FIELD, PAYLOAD_FIELD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final String roleArn;
    private final String operation;
    private final String hashKeyField;
    private final String hashKeyValue;
    private final String hashKeyType;
    private final String rangeKeyField;
    private final String rangeKeyValue;
    private final String rangeKeyType;
    private final String payloadField;

    private DynamoDBAction(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.roleArn = builder.roleArn;
        this.operation = builder.operation;
        this.hashKeyField = builder.hashKeyField;
        this.hashKeyValue = builder.hashKeyValue;
        this.hashKeyType = builder.hashKeyType;
        this.rangeKeyField = builder.rangeKeyField;
        this.rangeKeyValue = builder.rangeKeyValue;
        this.rangeKeyType = builder.rangeKeyType;
        this.payloadField = builder.payloadField;
    }

    public String tableName() {
        return this.tableName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String operation() {
        return this.operation;
    }

    public String hashKeyField() {
        return this.hashKeyField;
    }

    public String hashKeyValue() {
        return this.hashKeyValue;
    }

    public DynamoKeyType hashKeyType() {
        return DynamoKeyType.fromValue(this.hashKeyType);
    }

    public String hashKeyTypeAsString() {
        return this.hashKeyType;
    }

    public String rangeKeyField() {
        return this.rangeKeyField;
    }

    public String rangeKeyValue() {
        return this.rangeKeyValue;
    }

    public DynamoKeyType rangeKeyType() {
        return DynamoKeyType.fromValue(this.rangeKeyType);
    }

    public String rangeKeyTypeAsString() {
        return this.rangeKeyType;
    }

    public String payloadField() {
        return this.payloadField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyField());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeKeyField());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeKeyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadField());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBAction)) {
            return false;
        }
        DynamoDBAction other = (DynamoDBAction)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.hashKeyField(), other.hashKeyField()) && Objects.equals(this.hashKeyValue(), other.hashKeyValue()) && Objects.equals(this.hashKeyTypeAsString(), other.hashKeyTypeAsString()) && Objects.equals(this.rangeKeyField(), other.rangeKeyField()) && Objects.equals(this.rangeKeyValue(), other.rangeKeyValue()) && Objects.equals(this.rangeKeyTypeAsString(), other.rangeKeyTypeAsString()) && Objects.equals(this.payloadField(), other.payloadField());
    }

    public String toString() {
        return ToString.builder((String)"DynamoDBAction").add("TableName", (Object)this.tableName()).add("RoleArn", (Object)this.roleArn()).add("Operation", (Object)this.operation()).add("HashKeyField", (Object)this.hashKeyField()).add("HashKeyValue", (Object)this.hashKeyValue()).add("HashKeyType", (Object)this.hashKeyTypeAsString()).add("RangeKeyField", (Object)this.rangeKeyField()).add("RangeKeyValue", (Object)this.rangeKeyValue()).add("RangeKeyType", (Object)this.rangeKeyTypeAsString()).add("PayloadField", (Object)this.payloadField()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "hashKeyField": {
                return Optional.ofNullable(clazz.cast(this.hashKeyField()));
            }
            case "hashKeyValue": {
                return Optional.ofNullable(clazz.cast(this.hashKeyValue()));
            }
            case "hashKeyType": {
                return Optional.ofNullable(clazz.cast(this.hashKeyTypeAsString()));
            }
            case "rangeKeyField": {
                return Optional.ofNullable(clazz.cast(this.rangeKeyField()));
            }
            case "rangeKeyValue": {
                return Optional.ofNullable(clazz.cast(this.rangeKeyValue()));
            }
            case "rangeKeyType": {
                return Optional.ofNullable(clazz.cast(this.rangeKeyTypeAsString()));
            }
            case "payloadField": {
                return Optional.ofNullable(clazz.cast(this.payloadField()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamoDBAction, T> g) {
        return obj -> g.apply((DynamoDBAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String roleArn;
        private String operation;
        private String hashKeyField;
        private String hashKeyValue;
        private String hashKeyType;
        private String rangeKeyField;
        private String rangeKeyValue;
        private String rangeKeyType;
        private String payloadField;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBAction model) {
            this.tableName(model.tableName);
            this.roleArn(model.roleArn);
            this.operation(model.operation);
            this.hashKeyField(model.hashKeyField);
            this.hashKeyValue(model.hashKeyValue);
            this.hashKeyType(model.hashKeyType);
            this.rangeKeyField(model.rangeKeyField);
            this.rangeKeyValue(model.rangeKeyValue);
            this.rangeKeyType(model.rangeKeyType);
            this.payloadField(model.payloadField);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getHashKeyField() {
            return this.hashKeyField;
        }

        @Override
        public final Builder hashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
            return this;
        }

        public final void setHashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
        }

        public final String getHashKeyValue() {
            return this.hashKeyValue;
        }

        @Override
        public final Builder hashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
            return this;
        }

        public final void setHashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
        }

        public final String getHashKeyTypeAsString() {
            return this.hashKeyType;
        }

        @Override
        public final Builder hashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
            return this;
        }

        @Override
        public final Builder hashKeyType(DynamoKeyType hashKeyType) {
            this.hashKeyType(hashKeyType.toString());
            return this;
        }

        public final void setHashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
        }

        public final String getRangeKeyField() {
            return this.rangeKeyField;
        }

        @Override
        public final Builder rangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
            return this;
        }

        public final void setRangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
        }

        public final String getRangeKeyValue() {
            return this.rangeKeyValue;
        }

        @Override
        public final Builder rangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
            return this;
        }

        public final void setRangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
        }

        public final String getRangeKeyTypeAsString() {
            return this.rangeKeyType;
        }

        @Override
        public final Builder rangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
            return this;
        }

        @Override
        public final Builder rangeKeyType(DynamoKeyType rangeKeyType) {
            this.rangeKeyType(rangeKeyType.toString());
            return this;
        }

        public final void setRangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
        }

        public final String getPayloadField() {
            return this.payloadField;
        }

        @Override
        public final Builder payloadField(String payloadField) {
            this.payloadField = payloadField;
            return this;
        }

        public final void setPayloadField(String payloadField) {
            this.payloadField = payloadField;
        }

        public DynamoDBAction build() {
            return new DynamoDBAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamoDBAction> {
        public Builder tableName(String var1);

        public Builder roleArn(String var1);

        public Builder operation(String var1);

        public Builder hashKeyField(String var1);

        public Builder hashKeyValue(String var1);

        public Builder hashKeyType(String var1);

        public Builder hashKeyType(DynamoKeyType var1);

        public Builder rangeKeyField(String var1);

        public Builder rangeKeyValue(String var1);

        public Builder rangeKeyType(String var1);

        public Builder rangeKeyType(DynamoKeyType var1);

        public Builder payloadField(String var1);
    }
}

