/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IssuerCertificateIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IssuerCertificateIdentifier> {
    private static final SdkField<String> ISSUER_CERTIFICATE_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuerCertificateSubject").getter(IssuerCertificateIdentifier.getter(IssuerCertificateIdentifier::issuerCertificateSubject)).setter(IssuerCertificateIdentifier.setter(Builder::issuerCertificateSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerCertificateSubject").build()}).build();
    private static final SdkField<String> ISSUER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuerId").getter(IssuerCertificateIdentifier.getter(IssuerCertificateIdentifier::issuerId)).setter(IssuerCertificateIdentifier.setter(Builder::issuerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerId").build()}).build();
    private static final SdkField<String> ISSUER_CERTIFICATE_SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuerCertificateSerialNumber").getter(IssuerCertificateIdentifier.getter(IssuerCertificateIdentifier::issuerCertificateSerialNumber)).setter(IssuerCertificateIdentifier.setter(Builder::issuerCertificateSerialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerCertificateSerialNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_CERTIFICATE_SUBJECT_FIELD, ISSUER_ID_FIELD, ISSUER_CERTIFICATE_SERIAL_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IssuerCertificateIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String issuerCertificateSubject;
    private final String issuerId;
    private final String issuerCertificateSerialNumber;

    private IssuerCertificateIdentifier(BuilderImpl builder) {
        this.issuerCertificateSubject = builder.issuerCertificateSubject;
        this.issuerId = builder.issuerId;
        this.issuerCertificateSerialNumber = builder.issuerCertificateSerialNumber;
    }

    public final String issuerCertificateSubject() {
        return this.issuerCertificateSubject;
    }

    public final String issuerId() {
        return this.issuerId;
    }

    public final String issuerCertificateSerialNumber() {
        return this.issuerCertificateSerialNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerCertificateSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerCertificateSerialNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IssuerCertificateIdentifier)) {
            return false;
        }
        IssuerCertificateIdentifier other = (IssuerCertificateIdentifier)obj;
        return Objects.equals(this.issuerCertificateSubject(), other.issuerCertificateSubject()) && Objects.equals(this.issuerId(), other.issuerId()) && Objects.equals(this.issuerCertificateSerialNumber(), other.issuerCertificateSerialNumber());
    }

    public final String toString() {
        return ToString.builder((String)"IssuerCertificateIdentifier").add("IssuerCertificateSubject", (Object)this.issuerCertificateSubject()).add("IssuerId", (Object)this.issuerId()).add("IssuerCertificateSerialNumber", (Object)this.issuerCertificateSerialNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "issuerCertificateSubject": {
                return Optional.ofNullable(clazz.cast(this.issuerCertificateSubject()));
            }
            case "issuerId": {
                return Optional.ofNullable(clazz.cast(this.issuerId()));
            }
            case "issuerCertificateSerialNumber": {
                return Optional.ofNullable(clazz.cast(this.issuerCertificateSerialNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("issuerCertificateSubject", ISSUER_CERTIFICATE_SUBJECT_FIELD);
        map.put("issuerId", ISSUER_ID_FIELD);
        map.put("issuerCertificateSerialNumber", ISSUER_CERTIFICATE_SERIAL_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IssuerCertificateIdentifier, T> g) {
        return obj -> g.apply((IssuerCertificateIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issuerCertificateSubject;
        private String issuerId;
        private String issuerCertificateSerialNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(IssuerCertificateIdentifier model) {
            this.issuerCertificateSubject(model.issuerCertificateSubject);
            this.issuerId(model.issuerId);
            this.issuerCertificateSerialNumber(model.issuerCertificateSerialNumber);
        }

        public final String getIssuerCertificateSubject() {
            return this.issuerCertificateSubject;
        }

        public final void setIssuerCertificateSubject(String issuerCertificateSubject) {
            this.issuerCertificateSubject = issuerCertificateSubject;
        }

        @Override
        public final Builder issuerCertificateSubject(String issuerCertificateSubject) {
            this.issuerCertificateSubject = issuerCertificateSubject;
            return this;
        }

        public final String getIssuerId() {
            return this.issuerId;
        }

        public final void setIssuerId(String issuerId) {
            this.issuerId = issuerId;
        }

        @Override
        public final Builder issuerId(String issuerId) {
            this.issuerId = issuerId;
            return this;
        }

        public final String getIssuerCertificateSerialNumber() {
            return this.issuerCertificateSerialNumber;
        }

        public final void setIssuerCertificateSerialNumber(String issuerCertificateSerialNumber) {
            this.issuerCertificateSerialNumber = issuerCertificateSerialNumber;
        }

        @Override
        public final Builder issuerCertificateSerialNumber(String issuerCertificateSerialNumber) {
            this.issuerCertificateSerialNumber = issuerCertificateSerialNumber;
            return this;
        }

        public IssuerCertificateIdentifier build() {
            return new IssuerCertificateIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IssuerCertificateIdentifier> {
        public Builder issuerCertificateSubject(String var1);

        public Builder issuerId(String var1);

        public Builder issuerCertificateSerialNumber(String var1);
    }
}

