/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeManagedJobTemplateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, DescribeManagedJobTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(DescribeManagedJobTemplateRequest.getter(DescribeManagedJobTemplateRequest::templateName)).setter(DescribeManagedJobTemplateRequest.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("templateName").build()}).build();
    private static final SdkField<String> TEMPLATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateVersion").getter(DescribeManagedJobTemplateRequest.getter(DescribeManagedJobTemplateRequest::templateVersion)).setter(DescribeManagedJobTemplateRequest.setter(Builder::templateVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("templateVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeManagedJobTemplateRequest.memberNameToFieldInitializer();
    private final String templateName;
    private final String templateVersion;

    private DescribeManagedJobTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateVersion = builder.templateVersion;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String templateVersion() {
        return this.templateVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedJobTemplateRequest)) {
            return false;
        }
        DescribeManagedJobTemplateRequest other = (DescribeManagedJobTemplateRequest)((Object)obj);
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateVersion(), other.templateVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeManagedJobTemplateRequest").add("TemplateName", (Object)this.templateName()).add("TemplateVersion", (Object)this.templateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "templateVersion": {
                return Optional.ofNullable(clazz.cast(this.templateVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("templateName", TEMPLATE_NAME_FIELD);
        map.put("templateVersion", TEMPLATE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedJobTemplateRequest, T> g) {
        return obj -> g.apply((DescribeManagedJobTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String templateName;
        private String templateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedJobTemplateRequest model) {
            super(model);
            this.templateName(model.templateName);
            this.templateVersion(model.templateVersion);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateVersion() {
            return this.templateVersion;
        }

        public final void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        @Override
        public final Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeManagedJobTemplateRequest build() {
            return new DescribeManagedJobTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeManagedJobTemplateRequest> {
        public Builder templateName(String var1);

        public Builder templateVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

