/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommandParameterValueComparisonOperator {
    EQUALS("EQUALS"),
    NOT_EQUALS("NOT_EQUALS"),
    LESS_THAN("LESS_THAN"),
    LESS_THAN_EQUALS("LESS_THAN_EQUALS"),
    GREATER_THAN("GREATER_THAN"),
    GREATER_THAN_EQUALS("GREATER_THAN_EQUALS"),
    IN_SET("IN_SET"),
    NOT_IN_SET("NOT_IN_SET"),
    IN_RANGE("IN_RANGE"),
    NOT_IN_RANGE("NOT_IN_RANGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommandParameterValueComparisonOperator> VALUE_MAP;
    private final String value;

    private CommandParameterValueComparisonOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommandParameterValueComparisonOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommandParameterValueComparisonOperator> knownValues() {
        EnumSet<CommandParameterValueComparisonOperator> knownValues = EnumSet.allOf(CommandParameterValueComparisonOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommandParameterValueComparisonOperator.class, CommandParameterValueComparisonOperator::toString);
    }
}

