/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListThingTypesRequest;
import software.amazon.awssdk.services.iot.model.ListThingTypesResponse;
import software.amazon.awssdk.services.iot.model.ThingTypeDefinition;

public class ListThingTypesIterable
implements SdkIterable<ListThingTypesResponse> {
    private final IotClient client;
    private final ListThingTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingTypesIterable(IotClient client, ListThingTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListThingTypesResponseFetcher();
    }

    public Iterator<ListThingTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ThingTypeDefinition> thingTypes() {
        Function<ListThingTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.thingTypes() != null) {
                return response.thingTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingTypesResponseFetcher
    implements SyncPageFetcher<ListThingTypesResponse> {
        private ListThingTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListThingTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingTypesResponse nextPage(ListThingTypesResponse previousPage) {
            if (previousPage == null) {
                return ListThingTypesIterable.this.client.listThingTypes(ListThingTypesIterable.this.firstRequest);
            }
            return ListThingTypesIterable.this.client.listThingTypes((ListThingTypesRequest)((Object)ListThingTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

