/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.Field;
import software.amazon.awssdk.services.iot.model.FieldsCopier;
import software.amazon.awssdk.services.iot.model.ThingGroupIndexingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingGroupIndexingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingGroupIndexingConfiguration> {
    private static final SdkField<String> THING_GROUP_INDEXING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingGroupIndexingMode").getter(ThingGroupIndexingConfiguration.getter(ThingGroupIndexingConfiguration::thingGroupIndexingModeAsString)).setter(ThingGroupIndexingConfiguration.setter(Builder::thingGroupIndexingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupIndexingMode").build()}).build();
    private static final SdkField<List<Field>> MANAGED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedFields").getter(ThingGroupIndexingConfiguration.getter(ThingGroupIndexingConfiguration::managedFields)).setter(ThingGroupIndexingConfiguration.setter(Builder::managedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Field>> CUSTOM_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customFields").getter(ThingGroupIndexingConfiguration.getter(ThingGroupIndexingConfiguration::customFields)).setter(ThingGroupIndexingConfiguration.setter(Builder::customFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_INDEXING_MODE_FIELD, MANAGED_FIELDS_FIELD, CUSTOM_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ThingGroupIndexingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String thingGroupIndexingMode;
    private final List<Field> managedFields;
    private final List<Field> customFields;

    private ThingGroupIndexingConfiguration(BuilderImpl builder) {
        this.thingGroupIndexingMode = builder.thingGroupIndexingMode;
        this.managedFields = builder.managedFields;
        this.customFields = builder.customFields;
    }

    public final ThingGroupIndexingMode thingGroupIndexingMode() {
        return ThingGroupIndexingMode.fromValue(this.thingGroupIndexingMode);
    }

    public final String thingGroupIndexingModeAsString() {
        return this.thingGroupIndexingMode;
    }

    public final boolean hasManagedFields() {
        return this.managedFields != null && !(this.managedFields instanceof SdkAutoConstructList);
    }

    public final List<Field> managedFields() {
        return this.managedFields;
    }

    public final boolean hasCustomFields() {
        return this.customFields != null && !(this.customFields instanceof SdkAutoConstructList);
    }

    public final List<Field> customFields() {
        return this.customFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedFields() ? this.managedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomFields() ? this.customFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupIndexingConfiguration)) {
            return false;
        }
        ThingGroupIndexingConfiguration other = (ThingGroupIndexingConfiguration)obj;
        return Objects.equals(this.thingGroupIndexingModeAsString(), other.thingGroupIndexingModeAsString()) && this.hasManagedFields() == other.hasManagedFields() && Objects.equals(this.managedFields(), other.managedFields()) && this.hasCustomFields() == other.hasCustomFields() && Objects.equals(this.customFields(), other.customFields());
    }

    public final String toString() {
        return ToString.builder((String)"ThingGroupIndexingConfiguration").add("ThingGroupIndexingMode", (Object)this.thingGroupIndexingModeAsString()).add("ManagedFields", this.hasManagedFields() ? this.managedFields() : null).add("CustomFields", this.hasCustomFields() ? this.customFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroupIndexingMode": {
                return Optional.ofNullable(clazz.cast(this.thingGroupIndexingModeAsString()));
            }
            case "managedFields": {
                return Optional.ofNullable(clazz.cast(this.managedFields()));
            }
            case "customFields": {
                return Optional.ofNullable(clazz.cast(this.customFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("thingGroupIndexingMode", THING_GROUP_INDEXING_MODE_FIELD);
        map.put("managedFields", MANAGED_FIELDS_FIELD);
        map.put("customFields", CUSTOM_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThingGroupIndexingConfiguration, T> g) {
        return obj -> g.apply((ThingGroupIndexingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingGroupIndexingMode;
        private List<Field> managedFields = DefaultSdkAutoConstructList.getInstance();
        private List<Field> customFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupIndexingConfiguration model) {
            this.thingGroupIndexingMode(model.thingGroupIndexingMode);
            this.managedFields(model.managedFields);
            this.customFields(model.customFields);
        }

        public final String getThingGroupIndexingMode() {
            return this.thingGroupIndexingMode;
        }

        public final void setThingGroupIndexingMode(String thingGroupIndexingMode) {
            this.thingGroupIndexingMode = thingGroupIndexingMode;
        }

        @Override
        public final Builder thingGroupIndexingMode(String thingGroupIndexingMode) {
            this.thingGroupIndexingMode = thingGroupIndexingMode;
            return this;
        }

        @Override
        public final Builder thingGroupIndexingMode(ThingGroupIndexingMode thingGroupIndexingMode) {
            this.thingGroupIndexingMode(thingGroupIndexingMode == null ? null : thingGroupIndexingMode.toString());
            return this;
        }

        public final List<Field.Builder> getManagedFields() {
            List<Field.Builder> result = FieldsCopier.copyToBuilder(this.managedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedFields(Collection<Field.BuilderImpl> managedFields) {
            this.managedFields = FieldsCopier.copyFromBuilder(managedFields);
        }

        @Override
        public final Builder managedFields(Collection<Field> managedFields) {
            this.managedFields = FieldsCopier.copy(managedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFields(Field ... managedFields) {
            this.managedFields(Arrays.asList(managedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFields(Consumer<Field.Builder> ... managedFields) {
            this.managedFields(Stream.of(managedFields).map(c -> (Field)((Field.Builder)Field.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Field.Builder> getCustomFields() {
            List<Field.Builder> result = FieldsCopier.copyToBuilder(this.customFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomFields(Collection<Field.BuilderImpl> customFields) {
            this.customFields = FieldsCopier.copyFromBuilder(customFields);
        }

        @Override
        public final Builder customFields(Collection<Field> customFields) {
            this.customFields = FieldsCopier.copy(customFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFields(Field ... customFields) {
            this.customFields(Arrays.asList(customFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFields(Consumer<Field.Builder> ... customFields) {
            this.customFields(Stream.of(customFields).map(c -> (Field)((Field.Builder)Field.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ThingGroupIndexingConfiguration build() {
            return new ThingGroupIndexingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingGroupIndexingConfiguration> {
        public Builder thingGroupIndexingMode(String var1);

        public Builder thingGroupIndexingMode(ThingGroupIndexingMode var1);

        public Builder managedFields(Collection<Field> var1);

        public Builder managedFields(Field ... var1);

        public Builder managedFields(Consumer<Field.Builder> ... var1);

        public Builder customFields(Collection<Field> var1);

        public Builder customFields(Field ... var1);

        public Builder customFields(Consumer<Field.Builder> ... var1);
    }
}

