/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.CommandExecutionParameterMapCopier;
import software.amazon.awssdk.services.iot.model.CommandExecutionResult;
import software.amazon.awssdk.services.iot.model.CommandExecutionResultMapCopier;
import software.amazon.awssdk.services.iot.model.CommandExecutionStatus;
import software.amazon.awssdk.services.iot.model.CommandParameterValue;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.StatusReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCommandExecutionResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetCommandExecutionResponse> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::executionId)).setter(GetCommandExecutionResponse.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commandArn").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::commandArn)).setter(GetCommandExecutionResponse.setter(Builder::commandArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::targetArn)).setter(GetCommandExecutionResponse.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::statusAsString)).setter(GetCommandExecutionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusReason> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusReason").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::statusReason)).setter(GetCommandExecutionResponse.setter(Builder::statusReason)).constructor(StatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Map<String, CommandExecutionResult>> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("result").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::result)).setter(GetCommandExecutionResponse.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandExecutionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CommandParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::parameters)).setter(GetCommandExecutionResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> EXECUTION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executionTimeoutSeconds").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::executionTimeoutSeconds)).setter(GetCommandExecutionResponse.setter(Builder::executionTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutSeconds").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::createdAt)).setter(GetCommandExecutionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::lastUpdatedAt)).setter(GetCommandExecutionResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::startedAt)).setter(GetCommandExecutionResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::completedAt)).setter(GetCommandExecutionResponse.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()}).build();
    private static final SdkField<Instant> TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timeToLive").getter(GetCommandExecutionResponse.getter(GetCommandExecutionResponse::timeToLive)).setter(GetCommandExecutionResponse.setter(Builder::timeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeToLive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, COMMAND_ARN_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, RESULT_FIELD, PARAMETERS_FIELD, EXECUTION_TIMEOUT_SECONDS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD, TIME_TO_LIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCommandExecutionResponse.memberNameToFieldInitializer();
    private final String executionId;
    private final String commandArn;
    private final String targetArn;
    private final String status;
    private final StatusReason statusReason;
    private final Map<String, CommandExecutionResult> result;
    private final Map<String, CommandParameterValue> parameters;
    private final Long executionTimeoutSeconds;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Instant startedAt;
    private final Instant completedAt;
    private final Instant timeToLive;

    private GetCommandExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.commandArn = builder.commandArn;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.result = builder.result;
        this.parameters = builder.parameters;
        this.executionTimeoutSeconds = builder.executionTimeoutSeconds;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
        this.timeToLive = builder.timeToLive;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String commandArn() {
        return this.commandArn;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final CommandExecutionStatus status() {
        return CommandExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusReason statusReason() {
        return this.statusReason;
    }

    public final boolean hasResult() {
        return this.result != null && !(this.result instanceof SdkAutoConstructMap);
    }

    public final Map<String, CommandExecutionResult> result() {
        return this.result;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, CommandParameterValue> parameters() {
        return this.parameters;
    }

    public final Long executionTimeoutSeconds() {
        return this.executionTimeoutSeconds;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final Instant timeToLive() {
        return this.timeToLive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commandArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResult() ? this.result() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandExecutionResponse)) {
            return false;
        }
        GetCommandExecutionResponse other = (GetCommandExecutionResponse)((Object)obj);
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.commandArn(), other.commandArn()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasResult() == other.hasResult() && Objects.equals(this.result(), other.result()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.executionTimeoutSeconds(), other.executionTimeoutSeconds()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.timeToLive(), other.timeToLive());
    }

    public final String toString() {
        return ToString.builder((String)"GetCommandExecutionResponse").add("ExecutionId", (Object)this.executionId()).add("CommandArn", (Object)this.commandArn()).add("TargetArn", (Object)this.targetArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Result", this.hasResult() ? this.result() : null).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ExecutionTimeoutSeconds", (Object)this.executionTimeoutSeconds()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("StartedAt", (Object)this.startedAt()).add("CompletedAt", (Object)this.completedAt()).add("TimeToLive", (Object)this.timeToLive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "commandArn": {
                return Optional.ofNullable(clazz.cast(this.commandArn()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "executionTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.executionTimeoutSeconds()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "timeToLive": {
                return Optional.ofNullable(clazz.cast(this.timeToLive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("commandArn", COMMAND_ARN_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("executionTimeoutSeconds", EXECUTION_TIMEOUT_SECONDS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        map.put("timeToLive", TIME_TO_LIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommandExecutionResponse, T> g) {
        return obj -> g.apply((GetCommandExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String executionId;
        private String commandArn;
        private String targetArn;
        private String status;
        private StatusReason statusReason;
        private Map<String, CommandExecutionResult> result = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, CommandParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Long executionTimeoutSeconds;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Instant startedAt;
        private Instant completedAt;
        private Instant timeToLive;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandExecutionResponse model) {
            super(model);
            this.executionId(model.executionId);
            this.commandArn(model.commandArn);
            this.targetArn(model.targetArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.result(model.result);
            this.parameters(model.parameters);
            this.executionTimeoutSeconds(model.executionTimeoutSeconds);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.startedAt(model.startedAt);
            this.completedAt(model.completedAt);
            this.timeToLive(model.timeToLive);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getCommandArn() {
            return this.commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusReason.Builder getStatusReason() {
            return this.statusReason != null ? this.statusReason.toBuilder() : null;
        }

        public final void setStatusReason(StatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        @Override
        public final Builder statusReason(StatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, CommandExecutionResult.Builder> getResult() {
            Map<String, CommandExecutionResult.Builder> result = CommandExecutionResultMapCopier.copyToBuilder(this.result);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResult(Map<String, CommandExecutionResult.BuilderImpl> result) {
            this.result = CommandExecutionResultMapCopier.copyFromBuilder(result);
        }

        @Override
        public final Builder result(Map<String, CommandExecutionResult> result) {
            this.result = CommandExecutionResultMapCopier.copy(result);
            return this;
        }

        public final Map<String, CommandParameterValue.Builder> getParameters() {
            Map<String, CommandParameterValue.Builder> result = CommandExecutionParameterMapCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, CommandParameterValue.BuilderImpl> parameters) {
            this.parameters = CommandExecutionParameterMapCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, CommandParameterValue> parameters) {
            this.parameters = CommandExecutionParameterMapCopier.copy(parameters);
            return this;
        }

        public final Long getExecutionTimeoutSeconds() {
            return this.executionTimeoutSeconds;
        }

        public final void setExecutionTimeoutSeconds(Long executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
        }

        @Override
        public final Builder executionTimeoutSeconds(Long executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Instant getTimeToLive() {
            return this.timeToLive;
        }

        public final void setTimeToLive(Instant timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Override
        public final Builder timeToLive(Instant timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        @Override
        public GetCommandExecutionResponse build() {
            return new GetCommandExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCommandExecutionResponse> {
        public Builder executionId(String var1);

        public Builder commandArn(String var1);

        public Builder targetArn(String var1);

        public Builder status(String var1);

        public Builder status(CommandExecutionStatus var1);

        public Builder statusReason(StatusReason var1);

        default public Builder statusReason(Consumer<StatusReason.Builder> statusReason) {
            return this.statusReason((StatusReason)((StatusReason.Builder)StatusReason.builder().applyMutation(statusReason)).build());
        }

        public Builder result(Map<String, CommandExecutionResult> var1);

        public Builder parameters(Map<String, CommandParameterValue> var1);

        public Builder executionTimeoutSeconds(Long var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder completedAt(Instant var1);

        public Builder timeToLive(Instant var1);
    }
}

