/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ThingPrincipalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachThingPrincipalRequest
extends IotRequest
implements ToCopyableBuilder<Builder, AttachThingPrincipalRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(AttachThingPrincipalRequest.getter(AttachThingPrincipalRequest::thingName)).setter(AttachThingPrincipalRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principal").getter(AttachThingPrincipalRequest.getter(AttachThingPrincipalRequest::principal)).setter(AttachThingPrincipalRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-principal").build()}).build();
    private static final SdkField<String> THING_PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingPrincipalType").getter(AttachThingPrincipalRequest.getter(AttachThingPrincipalRequest::thingPrincipalTypeAsString)).setter(AttachThingPrincipalRequest.setter(Builder::thingPrincipalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingPrincipalType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, PRINCIPAL_FIELD, THING_PRINCIPAL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttachThingPrincipalRequest.memberNameToFieldInitializer();
    private final String thingName;
    private final String principal;
    private final String thingPrincipalType;

    private AttachThingPrincipalRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.principal = builder.principal;
        this.thingPrincipalType = builder.thingPrincipalType;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final String principal() {
        return this.principal;
    }

    public final ThingPrincipalType thingPrincipalType() {
        return ThingPrincipalType.fromValue(this.thingPrincipalType);
    }

    public final String thingPrincipalTypeAsString() {
        return this.thingPrincipalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingPrincipalTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachThingPrincipalRequest)) {
            return false;
        }
        AttachThingPrincipalRequest other = (AttachThingPrincipalRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.thingPrincipalTypeAsString(), other.thingPrincipalTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AttachThingPrincipalRequest").add("ThingName", (Object)this.thingName()).add("Principal", (Object)this.principal()).add("ThingPrincipalType", (Object)this.thingPrincipalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "thingPrincipalType": {
                return Optional.ofNullable(clazz.cast(this.thingPrincipalTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("thingName", THING_NAME_FIELD);
        map.put("x-amzn-principal", PRINCIPAL_FIELD);
        map.put("thingPrincipalType", THING_PRINCIPAL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttachThingPrincipalRequest, T> g) {
        return obj -> g.apply((AttachThingPrincipalRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private String principal;
        private String thingPrincipalType;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachThingPrincipalRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.principal(model.principal);
            this.thingPrincipalType(model.thingPrincipalType);
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getThingPrincipalType() {
            return this.thingPrincipalType;
        }

        public final void setThingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
        }

        @Override
        public final Builder thingPrincipalType(String thingPrincipalType) {
            this.thingPrincipalType = thingPrincipalType;
            return this;
        }

        @Override
        public final Builder thingPrincipalType(ThingPrincipalType thingPrincipalType) {
            this.thingPrincipalType(thingPrincipalType == null ? null : thingPrincipalType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachThingPrincipalRequest build() {
            return new AttachThingPrincipalRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachThingPrincipalRequest> {
        public Builder thingName(String var1);

        public Builder principal(String var1);

        public Builder thingPrincipalType(String var1);

        public Builder thingPrincipalType(ThingPrincipalType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

