/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuthorizerSummary;
import software.amazon.awssdk.services.iot.model.AuthorizersCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuthorizersResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListAuthorizersResponse> {
    private static final SdkField<List<AuthorizerSummary>> AUTHORIZERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authorizers").getter(ListAuthorizersResponse.getter(ListAuthorizersResponse::authorizers)).setter(ListAuthorizersResponse.setter(Builder::authorizers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextMarker").getter(ListAuthorizersResponse.getter(ListAuthorizersResponse::nextMarker)).setter(ListAuthorizersResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZERS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAuthorizersResponse.memberNameToFieldInitializer();
    private final List<AuthorizerSummary> authorizers;
    private final String nextMarker;

    private ListAuthorizersResponse(BuilderImpl builder) {
        super(builder);
        this.authorizers = builder.authorizers;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasAuthorizers() {
        return this.authorizers != null && !(this.authorizers instanceof SdkAutoConstructList);
    }

    public final List<AuthorizerSummary> authorizers() {
        return this.authorizers;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizers() ? this.authorizers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuthorizersResponse)) {
            return false;
        }
        ListAuthorizersResponse other = (ListAuthorizersResponse)((Object)obj);
        return this.hasAuthorizers() == other.hasAuthorizers() && Objects.equals(this.authorizers(), other.authorizers()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListAuthorizersResponse").add("Authorizers", this.hasAuthorizers() ? this.authorizers() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizers": {
                return Optional.ofNullable(clazz.cast(this.authorizers()));
            }
            case "nextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authorizers", AUTHORIZERS_FIELD);
        map.put("nextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAuthorizersResponse, T> g) {
        return obj -> g.apply((ListAuthorizersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<AuthorizerSummary> authorizers = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuthorizersResponse model) {
            super(model);
            this.authorizers(model.authorizers);
            this.nextMarker(model.nextMarker);
        }

        public final List<AuthorizerSummary.Builder> getAuthorizers() {
            List<AuthorizerSummary.Builder> result = AuthorizersCopier.copyToBuilder(this.authorizers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizers(Collection<AuthorizerSummary.BuilderImpl> authorizers) {
            this.authorizers = AuthorizersCopier.copyFromBuilder(authorizers);
        }

        @Override
        public final Builder authorizers(Collection<AuthorizerSummary> authorizers) {
            this.authorizers = AuthorizersCopier.copy(authorizers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizers(AuthorizerSummary ... authorizers) {
            this.authorizers(Arrays.asList(authorizers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizers(Consumer<AuthorizerSummary.Builder> ... authorizers) {
            this.authorizers(Stream.of(authorizers).map(c -> (AuthorizerSummary)((AuthorizerSummary.Builder)AuthorizerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListAuthorizersResponse build() {
            return new ListAuthorizersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuthorizersResponse> {
        public Builder authorizers(Collection<AuthorizerSummary> var1);

        public Builder authorizers(AuthorizerSummary ... var1);

        public Builder authorizers(Consumer<AuthorizerSummary.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

