/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ApplicationProtocol;
import software.amazon.awssdk.services.iot.model.AuthenticationType;
import software.amazon.awssdk.services.iot.model.AuthorizerConfig;
import software.amazon.awssdk.services.iot.model.ClientCertificateConfig;
import software.amazon.awssdk.services.iot.model.DomainConfigurationStatus;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ServerCertificateConfig;
import software.amazon.awssdk.services.iot.model.TlsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainConfigurationRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateDomainConfigurationRequest> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationName").getter(UpdateDomainConfigurationRequest.getter(UpdateDomainConfigurationRequest::domainConfigurationName)).setter(UpdateDomainConfigurationRequest.setter(Builder::domainConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainConfigurationName").build()}).build();
    private static final SdkField<AuthorizerConfig> AUTHORIZER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizerConfig").getter(UpdateDomainConfigurationRequest.getter(UpdateDomainConfigurationRequest::authorizerConfig)).setter(UpdateDomainConfigurationRequest.setter(Builder::authorizerConfig)).constructor(AuthorizerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfig").build()}).build();
    private static final SdkField<String> DOMAIN_CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationStatus").getter(UpdateDomainConfigurationRequest.getter(UpdateDomainConfigurationRequest::domainConfigurationStatusAsString)).setter(UpdateDomainConfigurationRequest.setter(Builder::domainConfigurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationStatus").build()}).build();
    private static final SdkField<Boolean> REMOVE_AUTHORIZER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("removeAuthorizerConfig").getter(UpdateDomainConfigurationRequest.getter(UpdateDomainConfigurationRequest::removeAuthorizerConfig)).setter(UpdateDomainConfigurationRequest.setter(Builder::removeAuthorizerConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAuthorizerConfig").build()}).build();
    private static final SdkField<TlsConfig> TLS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tlsConfig").getter(UpdateDomainConfigurationRequest.getter(UpdateDomainConfigurationRequest::tlsConfig)).setter(UpdateDomainConfigurationRequest.setter(Builder::tlsConfig)).constructor(TlsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsConfig").build()}).build();
    private static final SdkField<ServerCertificateConfig> SERVER_CERTIFICATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverCertificateConfig").getter(UpdateDomainConfigurationRequest.getter(UpdateDomainConfigurationRequest::serverCertificateConfig)).setter(UpdateDomainConfigurationRequest.setter(Builder::serverCertificateConfig)).constructor(ServerCertificateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificateConfig").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationType").getter(UpdateDomainConfigurationRequest.getter(UpdateDomainConfigurationRequest::authenticationTypeAsString)).setter(UpdateDomainConfigurationRequest.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()}).build();
    private static final SdkField<String> APPLICATION_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationProtocol").getter(UpdateDomainConfigurationRequest.getter(UpdateDomainConfigurationRequest::applicationProtocolAsString)).setter(UpdateDomainConfigurationRequest.setter(Builder::applicationProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationProtocol").build()}).build();
    private static final SdkField<ClientCertificateConfig> CLIENT_CERTIFICATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("clientCertificateConfig").getter(UpdateDomainConfigurationRequest.getter(UpdateDomainConfigurationRequest::clientCertificateConfig)).setter(UpdateDomainConfigurationRequest.setter(Builder::clientCertificateConfig)).constructor(ClientCertificateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIGURATION_NAME_FIELD, AUTHORIZER_CONFIG_FIELD, DOMAIN_CONFIGURATION_STATUS_FIELD, REMOVE_AUTHORIZER_CONFIG_FIELD, TLS_CONFIG_FIELD, SERVER_CERTIFICATE_CONFIG_FIELD, AUTHENTICATION_TYPE_FIELD, APPLICATION_PROTOCOL_FIELD, CLIENT_CERTIFICATE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDomainConfigurationRequest.memberNameToFieldInitializer();
    private final String domainConfigurationName;
    private final AuthorizerConfig authorizerConfig;
    private final String domainConfigurationStatus;
    private final Boolean removeAuthorizerConfig;
    private final TlsConfig tlsConfig;
    private final ServerCertificateConfig serverCertificateConfig;
    private final String authenticationType;
    private final String applicationProtocol;
    private final ClientCertificateConfig clientCertificateConfig;

    private UpdateDomainConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.authorizerConfig = builder.authorizerConfig;
        this.domainConfigurationStatus = builder.domainConfigurationStatus;
        this.removeAuthorizerConfig = builder.removeAuthorizerConfig;
        this.tlsConfig = builder.tlsConfig;
        this.serverCertificateConfig = builder.serverCertificateConfig;
        this.authenticationType = builder.authenticationType;
        this.applicationProtocol = builder.applicationProtocol;
        this.clientCertificateConfig = builder.clientCertificateConfig;
    }

    public final String domainConfigurationName() {
        return this.domainConfigurationName;
    }

    public final AuthorizerConfig authorizerConfig() {
        return this.authorizerConfig;
    }

    public final DomainConfigurationStatus domainConfigurationStatus() {
        return DomainConfigurationStatus.fromValue(this.domainConfigurationStatus);
    }

    public final String domainConfigurationStatusAsString() {
        return this.domainConfigurationStatus;
    }

    public final Boolean removeAuthorizerConfig() {
        return this.removeAuthorizerConfig;
    }

    public final TlsConfig tlsConfig() {
        return this.tlsConfig;
    }

    public final ServerCertificateConfig serverCertificateConfig() {
        return this.serverCertificateConfig;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final ApplicationProtocol applicationProtocol() {
        return ApplicationProtocol.fromValue(this.applicationProtocol);
    }

    public final String applicationProtocolAsString() {
        return this.applicationProtocol;
    }

    public final ClientCertificateConfig clientCertificateConfig() {
        return this.clientCertificateConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeAuthorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainConfigurationRequest)) {
            return false;
        }
        UpdateDomainConfigurationRequest other = (UpdateDomainConfigurationRequest)((Object)obj);
        return Objects.equals(this.domainConfigurationName(), other.domainConfigurationName()) && Objects.equals(this.authorizerConfig(), other.authorizerConfig()) && Objects.equals(this.domainConfigurationStatusAsString(), other.domainConfigurationStatusAsString()) && Objects.equals(this.removeAuthorizerConfig(), other.removeAuthorizerConfig()) && Objects.equals(this.tlsConfig(), other.tlsConfig()) && Objects.equals(this.serverCertificateConfig(), other.serverCertificateConfig()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.applicationProtocolAsString(), other.applicationProtocolAsString()) && Objects.equals(this.clientCertificateConfig(), other.clientCertificateConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDomainConfigurationRequest").add("DomainConfigurationName", (Object)this.domainConfigurationName()).add("AuthorizerConfig", (Object)this.authorizerConfig()).add("DomainConfigurationStatus", (Object)this.domainConfigurationStatusAsString()).add("RemoveAuthorizerConfig", (Object)this.removeAuthorizerConfig()).add("TlsConfig", (Object)this.tlsConfig()).add("ServerCertificateConfig", (Object)this.serverCertificateConfig()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("ApplicationProtocol", (Object)this.applicationProtocolAsString()).add("ClientCertificateConfig", (Object)this.clientCertificateConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationName()));
            }
            case "authorizerConfig": {
                return Optional.ofNullable(clazz.cast(this.authorizerConfig()));
            }
            case "domainConfigurationStatus": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationStatusAsString()));
            }
            case "removeAuthorizerConfig": {
                return Optional.ofNullable(clazz.cast(this.removeAuthorizerConfig()));
            }
            case "tlsConfig": {
                return Optional.ofNullable(clazz.cast(this.tlsConfig()));
            }
            case "serverCertificateConfig": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateConfig()));
            }
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "applicationProtocol": {
                return Optional.ofNullable(clazz.cast(this.applicationProtocolAsString()));
            }
            case "clientCertificateConfig": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainConfigurationName", DOMAIN_CONFIGURATION_NAME_FIELD);
        map.put("authorizerConfig", AUTHORIZER_CONFIG_FIELD);
        map.put("domainConfigurationStatus", DOMAIN_CONFIGURATION_STATUS_FIELD);
        map.put("removeAuthorizerConfig", REMOVE_AUTHORIZER_CONFIG_FIELD);
        map.put("tlsConfig", TLS_CONFIG_FIELD);
        map.put("serverCertificateConfig", SERVER_CERTIFICATE_CONFIG_FIELD);
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("applicationProtocol", APPLICATION_PROTOCOL_FIELD);
        map.put("clientCertificateConfig", CLIENT_CERTIFICATE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateDomainConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String domainConfigurationName;
        private AuthorizerConfig authorizerConfig;
        private String domainConfigurationStatus;
        private Boolean removeAuthorizerConfig;
        private TlsConfig tlsConfig;
        private ServerCertificateConfig serverCertificateConfig;
        private String authenticationType;
        private String applicationProtocol;
        private ClientCertificateConfig clientCertificateConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainConfigurationRequest model) {
            super(model);
            this.domainConfigurationName(model.domainConfigurationName);
            this.authorizerConfig(model.authorizerConfig);
            this.domainConfigurationStatus(model.domainConfigurationStatus);
            this.removeAuthorizerConfig(model.removeAuthorizerConfig);
            this.tlsConfig(model.tlsConfig);
            this.serverCertificateConfig(model.serverCertificateConfig);
            this.authenticationType(model.authenticationType);
            this.applicationProtocol(model.applicationProtocol);
            this.clientCertificateConfig(model.clientCertificateConfig);
        }

        public final String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final AuthorizerConfig.Builder getAuthorizerConfig() {
            return this.authorizerConfig != null ? this.authorizerConfig.toBuilder() : null;
        }

        public final void setAuthorizerConfig(AuthorizerConfig.BuilderImpl authorizerConfig) {
            this.authorizerConfig = authorizerConfig != null ? authorizerConfig.build() : null;
        }

        @Override
        public final Builder authorizerConfig(AuthorizerConfig authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        public final String getDomainConfigurationStatus() {
            return this.domainConfigurationStatus;
        }

        public final void setDomainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
        }

        @Override
        public final Builder domainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
            return this;
        }

        @Override
        public final Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus) {
            this.domainConfigurationStatus(domainConfigurationStatus == null ? null : domainConfigurationStatus.toString());
            return this;
        }

        public final Boolean getRemoveAuthorizerConfig() {
            return this.removeAuthorizerConfig;
        }

        public final void setRemoveAuthorizerConfig(Boolean removeAuthorizerConfig) {
            this.removeAuthorizerConfig = removeAuthorizerConfig;
        }

        @Override
        public final Builder removeAuthorizerConfig(Boolean removeAuthorizerConfig) {
            this.removeAuthorizerConfig = removeAuthorizerConfig;
            return this;
        }

        public final TlsConfig.Builder getTlsConfig() {
            return this.tlsConfig != null ? this.tlsConfig.toBuilder() : null;
        }

        public final void setTlsConfig(TlsConfig.BuilderImpl tlsConfig) {
            this.tlsConfig = tlsConfig != null ? tlsConfig.build() : null;
        }

        @Override
        public final Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public final ServerCertificateConfig.Builder getServerCertificateConfig() {
            return this.serverCertificateConfig != null ? this.serverCertificateConfig.toBuilder() : null;
        }

        public final void setServerCertificateConfig(ServerCertificateConfig.BuilderImpl serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig != null ? serverCertificateConfig.build() : null;
        }

        @Override
        public final Builder serverCertificateConfig(ServerCertificateConfig serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getApplicationProtocol() {
            return this.applicationProtocol;
        }

        public final void setApplicationProtocol(String applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
        }

        @Override
        public final Builder applicationProtocol(String applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
            return this;
        }

        @Override
        public final Builder applicationProtocol(ApplicationProtocol applicationProtocol) {
            this.applicationProtocol(applicationProtocol == null ? null : applicationProtocol.toString());
            return this;
        }

        public final ClientCertificateConfig.Builder getClientCertificateConfig() {
            return this.clientCertificateConfig != null ? this.clientCertificateConfig.toBuilder() : null;
        }

        public final void setClientCertificateConfig(ClientCertificateConfig.BuilderImpl clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig != null ? clientCertificateConfig.build() : null;
        }

        @Override
        public final Builder clientCertificateConfig(ClientCertificateConfig clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainConfigurationRequest build() {
            return new UpdateDomainConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainConfigurationRequest> {
        public Builder domainConfigurationName(String var1);

        public Builder authorizerConfig(AuthorizerConfig var1);

        default public Builder authorizerConfig(Consumer<AuthorizerConfig.Builder> authorizerConfig) {
            return this.authorizerConfig((AuthorizerConfig)((AuthorizerConfig.Builder)AuthorizerConfig.builder().applyMutation(authorizerConfig)).build());
        }

        public Builder domainConfigurationStatus(String var1);

        public Builder domainConfigurationStatus(DomainConfigurationStatus var1);

        public Builder removeAuthorizerConfig(Boolean var1);

        public Builder tlsConfig(TlsConfig var1);

        default public Builder tlsConfig(Consumer<TlsConfig.Builder> tlsConfig) {
            return this.tlsConfig((TlsConfig)((TlsConfig.Builder)TlsConfig.builder().applyMutation(tlsConfig)).build());
        }

        public Builder serverCertificateConfig(ServerCertificateConfig var1);

        default public Builder serverCertificateConfig(Consumer<ServerCertificateConfig.Builder> serverCertificateConfig) {
            return this.serverCertificateConfig((ServerCertificateConfig)((ServerCertificateConfig.Builder)ServerCertificateConfig.builder().applyMutation(serverCertificateConfig)).build());
        }

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder applicationProtocol(String var1);

        public Builder applicationProtocol(ApplicationProtocol var1);

        public Builder clientCertificateConfig(ClientCertificateConfig var1);

        default public Builder clientCertificateConfig(Consumer<ClientCertificateConfig.Builder> clientCertificateConfig) {
            return this.clientCertificateConfig((ClientCertificateConfig)((ClientCertificateConfig.Builder)ClientCertificateConfig.builder().applyMutation(clientCertificateConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

