/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.TopicRulePayload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceTopicRuleRequest
extends IotRequest
implements ToCopyableBuilder<Builder, ReplaceTopicRuleRequest> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleName").getter(ReplaceTopicRuleRequest.getter(ReplaceTopicRuleRequest::ruleName)).setter(ReplaceTopicRuleRequest.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ruleName").build()}).build();
    private static final SdkField<TopicRulePayload> TOPIC_RULE_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topicRulePayload").getter(ReplaceTopicRuleRequest.getter(ReplaceTopicRuleRequest::topicRulePayload)).setter(ReplaceTopicRuleRequest.setter(Builder::topicRulePayload)).constructor(TopicRulePayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicRulePayload").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, TOPIC_RULE_PAYLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplaceTopicRuleRequest.memberNameToFieldInitializer();
    private final String ruleName;
    private final TopicRulePayload topicRulePayload;

    private ReplaceTopicRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.topicRulePayload = builder.topicRulePayload;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final TopicRulePayload topicRulePayload() {
        return this.topicRulePayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicRulePayload());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceTopicRuleRequest)) {
            return false;
        }
        ReplaceTopicRuleRequest other = (ReplaceTopicRuleRequest)((Object)obj);
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.topicRulePayload(), other.topicRulePayload());
    }

    public final String toString() {
        return ToString.builder((String)"ReplaceTopicRuleRequest").add("RuleName", (Object)this.ruleName()).add("TopicRulePayload", (Object)this.topicRulePayload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "topicRulePayload": {
                return Optional.ofNullable(clazz.cast(this.topicRulePayload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleName", RULE_NAME_FIELD);
        map.put("topicRulePayload", TOPIC_RULE_PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplaceTopicRuleRequest, T> g) {
        return obj -> g.apply((ReplaceTopicRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String ruleName;
        private TopicRulePayload topicRulePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceTopicRuleRequest model) {
            super(model);
            this.ruleName(model.ruleName);
            this.topicRulePayload(model.topicRulePayload);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final TopicRulePayload.Builder getTopicRulePayload() {
            return this.topicRulePayload != null ? this.topicRulePayload.toBuilder() : null;
        }

        public final void setTopicRulePayload(TopicRulePayload.BuilderImpl topicRulePayload) {
            this.topicRulePayload = topicRulePayload != null ? topicRulePayload.build() : null;
        }

        @Override
        public final Builder topicRulePayload(TopicRulePayload topicRulePayload) {
            this.topicRulePayload = topicRulePayload;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceTopicRuleRequest build() {
            return new ReplaceTopicRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplaceTopicRuleRequest> {
        public Builder ruleName(String var1);

        public Builder topicRulePayload(TopicRulePayload var1);

        default public Builder topicRulePayload(Consumer<TopicRulePayload.Builder> topicRulePayload) {
            return this.topicRulePayload((TopicRulePayload)((TopicRulePayload.Builder)TopicRulePayload.builder().applyMutation(topicRulePayload)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

