/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.PercentPair;
import software.amazon.awssdk.services.iot.model.PercentilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPercentilesResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetPercentilesResponse> {
    private static final SdkField<List<PercentPair>> PERCENTILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("percentiles").getter(GetPercentilesResponse.getter(GetPercentilesResponse::percentiles)).setter(GetPercentilesResponse.setter(Builder::percentiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PercentPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPercentilesResponse.memberNameToFieldInitializer();
    private final List<PercentPair> percentiles;

    private GetPercentilesResponse(BuilderImpl builder) {
        super(builder);
        this.percentiles = builder.percentiles;
    }

    public final boolean hasPercentiles() {
        return this.percentiles != null && !(this.percentiles instanceof SdkAutoConstructList);
    }

    public final List<PercentPair> percentiles() {
        return this.percentiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPercentiles() ? this.percentiles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPercentilesResponse)) {
            return false;
        }
        GetPercentilesResponse other = (GetPercentilesResponse)((Object)obj);
        return this.hasPercentiles() == other.hasPercentiles() && Objects.equals(this.percentiles(), other.percentiles());
    }

    public final String toString() {
        return ToString.builder((String)"GetPercentilesResponse").add("Percentiles", this.hasPercentiles() ? this.percentiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "percentiles": {
                return Optional.ofNullable(clazz.cast(this.percentiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PercentPair>>> map = new HashMap<String, SdkField<List<PercentPair>>>();
        map.put("percentiles", PERCENTILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPercentilesResponse, T> g) {
        return obj -> g.apply((GetPercentilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<PercentPair> percentiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPercentilesResponse model) {
            super(model);
            this.percentiles(model.percentiles);
        }

        public final List<PercentPair.Builder> getPercentiles() {
            List<PercentPair.Builder> result = PercentilesCopier.copyToBuilder(this.percentiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPercentiles(Collection<PercentPair.BuilderImpl> percentiles) {
            this.percentiles = PercentilesCopier.copyFromBuilder(percentiles);
        }

        @Override
        public final Builder percentiles(Collection<PercentPair> percentiles) {
            this.percentiles = PercentilesCopier.copy(percentiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder percentiles(PercentPair ... percentiles) {
            this.percentiles(Arrays.asList(percentiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder percentiles(Consumer<PercentPair.Builder> ... percentiles) {
            this.percentiles(Stream.of(percentiles).map(c -> (PercentPair)((PercentPair.Builder)PercentPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetPercentilesResponse build() {
            return new GetPercentilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPercentilesResponse> {
        public Builder percentiles(Collection<PercentPair> var1);

        public Builder percentiles(PercentPair ... var1);

        public Builder percentiles(Consumer<PercentPair.Builder> ... var1);
    }
}

