/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.ApplicationProtocol;
import software.amazon.awssdk.services.iot.model.AuthenticationType;
import software.amazon.awssdk.services.iot.model.AuthorizerConfig;
import software.amazon.awssdk.services.iot.model.ClientCertificateConfig;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.ServerCertificateArnsCopier;
import software.amazon.awssdk.services.iot.model.ServerCertificateConfig;
import software.amazon.awssdk.services.iot.model.ServiceType;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.services.iot.model.TlsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainConfigurationRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateDomainConfigurationRequest> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationName").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::domainConfigurationName)).setter(CreateDomainConfigurationRequest.setter(Builder::domainConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainConfigurationName").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::domainName)).setter(CreateDomainConfigurationRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<List<String>> SERVER_CERTIFICATE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serverCertificateArns").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::serverCertificateArns)).setter(CreateDomainConfigurationRequest.setter(Builder::serverCertificateArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificateArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VALIDATION_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationCertificateArn").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::validationCertificateArn)).setter(CreateDomainConfigurationRequest.setter(Builder::validationCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationCertificateArn").build()}).build();
    private static final SdkField<AuthorizerConfig> AUTHORIZER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizerConfig").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::authorizerConfig)).setter(CreateDomainConfigurationRequest.setter(Builder::authorizerConfig)).constructor(AuthorizerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfig").build()}).build();
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceType").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::serviceTypeAsString)).setter(CreateDomainConfigurationRequest.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::tags)).setter(CreateDomainConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TlsConfig> TLS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tlsConfig").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::tlsConfig)).setter(CreateDomainConfigurationRequest.setter(Builder::tlsConfig)).constructor(TlsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsConfig").build()}).build();
    private static final SdkField<ServerCertificateConfig> SERVER_CERTIFICATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverCertificateConfig").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::serverCertificateConfig)).setter(CreateDomainConfigurationRequest.setter(Builder::serverCertificateConfig)).constructor(ServerCertificateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificateConfig").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationType").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::authenticationTypeAsString)).setter(CreateDomainConfigurationRequest.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()}).build();
    private static final SdkField<String> APPLICATION_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationProtocol").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::applicationProtocolAsString)).setter(CreateDomainConfigurationRequest.setter(Builder::applicationProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationProtocol").build()}).build();
    private static final SdkField<ClientCertificateConfig> CLIENT_CERTIFICATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("clientCertificateConfig").getter(CreateDomainConfigurationRequest.getter(CreateDomainConfigurationRequest::clientCertificateConfig)).setter(CreateDomainConfigurationRequest.setter(Builder::clientCertificateConfig)).constructor(ClientCertificateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIGURATION_NAME_FIELD, DOMAIN_NAME_FIELD, SERVER_CERTIFICATE_ARNS_FIELD, VALIDATION_CERTIFICATE_ARN_FIELD, AUTHORIZER_CONFIG_FIELD, SERVICE_TYPE_FIELD, TAGS_FIELD, TLS_CONFIG_FIELD, SERVER_CERTIFICATE_CONFIG_FIELD, AUTHENTICATION_TYPE_FIELD, APPLICATION_PROTOCOL_FIELD, CLIENT_CERTIFICATE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainConfigurationRequest.memberNameToFieldInitializer();
    private final String domainConfigurationName;
    private final String domainName;
    private final List<String> serverCertificateArns;
    private final String validationCertificateArn;
    private final AuthorizerConfig authorizerConfig;
    private final String serviceType;
    private final List<Tag> tags;
    private final TlsConfig tlsConfig;
    private final ServerCertificateConfig serverCertificateConfig;
    private final String authenticationType;
    private final String applicationProtocol;
    private final ClientCertificateConfig clientCertificateConfig;

    private CreateDomainConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.domainName = builder.domainName;
        this.serverCertificateArns = builder.serverCertificateArns;
        this.validationCertificateArn = builder.validationCertificateArn;
        this.authorizerConfig = builder.authorizerConfig;
        this.serviceType = builder.serviceType;
        this.tags = builder.tags;
        this.tlsConfig = builder.tlsConfig;
        this.serverCertificateConfig = builder.serverCertificateConfig;
        this.authenticationType = builder.authenticationType;
        this.applicationProtocol = builder.applicationProtocol;
        this.clientCertificateConfig = builder.clientCertificateConfig;
    }

    public final String domainConfigurationName() {
        return this.domainConfigurationName;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasServerCertificateArns() {
        return this.serverCertificateArns != null && !(this.serverCertificateArns instanceof SdkAutoConstructList);
    }

    public final List<String> serverCertificateArns() {
        return this.serverCertificateArns;
    }

    public final String validationCertificateArn() {
        return this.validationCertificateArn;
    }

    public final AuthorizerConfig authorizerConfig() {
        return this.authorizerConfig;
    }

    public final ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final TlsConfig tlsConfig() {
        return this.tlsConfig;
    }

    public final ServerCertificateConfig serverCertificateConfig() {
        return this.serverCertificateConfig;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final ApplicationProtocol applicationProtocol() {
        return ApplicationProtocol.fromValue(this.applicationProtocol);
    }

    public final String applicationProtocolAsString() {
        return this.applicationProtocol;
    }

    public final ClientCertificateConfig clientCertificateConfig() {
        return this.clientCertificateConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerCertificateArns() ? this.serverCertificateArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.validationCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainConfigurationRequest)) {
            return false;
        }
        CreateDomainConfigurationRequest other = (CreateDomainConfigurationRequest)((Object)obj);
        return Objects.equals(this.domainConfigurationName(), other.domainConfigurationName()) && Objects.equals(this.domainName(), other.domainName()) && this.hasServerCertificateArns() == other.hasServerCertificateArns() && Objects.equals(this.serverCertificateArns(), other.serverCertificateArns()) && Objects.equals(this.validationCertificateArn(), other.validationCertificateArn()) && Objects.equals(this.authorizerConfig(), other.authorizerConfig()) && Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tlsConfig(), other.tlsConfig()) && Objects.equals(this.serverCertificateConfig(), other.serverCertificateConfig()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.applicationProtocolAsString(), other.applicationProtocolAsString()) && Objects.equals(this.clientCertificateConfig(), other.clientCertificateConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainConfigurationRequest").add("DomainConfigurationName", (Object)this.domainConfigurationName()).add("DomainName", (Object)this.domainName()).add("ServerCertificateArns", this.hasServerCertificateArns() ? this.serverCertificateArns() : null).add("ValidationCertificateArn", (Object)this.validationCertificateArn()).add("AuthorizerConfig", (Object)this.authorizerConfig()).add("ServiceType", (Object)this.serviceTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("TlsConfig", (Object)this.tlsConfig()).add("ServerCertificateConfig", (Object)this.serverCertificateConfig()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("ApplicationProtocol", (Object)this.applicationProtocolAsString()).add("ClientCertificateConfig", (Object)this.clientCertificateConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationName()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "serverCertificateArns": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateArns()));
            }
            case "validationCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.validationCertificateArn()));
            }
            case "authorizerConfig": {
                return Optional.ofNullable(clazz.cast(this.authorizerConfig()));
            }
            case "serviceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "tlsConfig": {
                return Optional.ofNullable(clazz.cast(this.tlsConfig()));
            }
            case "serverCertificateConfig": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateConfig()));
            }
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "applicationProtocol": {
                return Optional.ofNullable(clazz.cast(this.applicationProtocolAsString()));
            }
            case "clientCertificateConfig": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainConfigurationName", DOMAIN_CONFIGURATION_NAME_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("serverCertificateArns", SERVER_CERTIFICATE_ARNS_FIELD);
        map.put("validationCertificateArn", VALIDATION_CERTIFICATE_ARN_FIELD);
        map.put("authorizerConfig", AUTHORIZER_CONFIG_FIELD);
        map.put("serviceType", SERVICE_TYPE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("tlsConfig", TLS_CONFIG_FIELD);
        map.put("serverCertificateConfig", SERVER_CERTIFICATE_CONFIG_FIELD);
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("applicationProtocol", APPLICATION_PROTOCOL_FIELD);
        map.put("clientCertificateConfig", CLIENT_CERTIFICATE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainConfigurationRequest, T> g) {
        return obj -> g.apply((CreateDomainConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String domainConfigurationName;
        private String domainName;
        private List<String> serverCertificateArns = DefaultSdkAutoConstructList.getInstance();
        private String validationCertificateArn;
        private AuthorizerConfig authorizerConfig;
        private String serviceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private TlsConfig tlsConfig;
        private ServerCertificateConfig serverCertificateConfig;
        private String authenticationType;
        private String applicationProtocol;
        private ClientCertificateConfig clientCertificateConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainConfigurationRequest model) {
            super(model);
            this.domainConfigurationName(model.domainConfigurationName);
            this.domainName(model.domainName);
            this.serverCertificateArns(model.serverCertificateArns);
            this.validationCertificateArn(model.validationCertificateArn);
            this.authorizerConfig(model.authorizerConfig);
            this.serviceType(model.serviceType);
            this.tags(model.tags);
            this.tlsConfig(model.tlsConfig);
            this.serverCertificateConfig(model.serverCertificateConfig);
            this.authenticationType(model.authenticationType);
            this.applicationProtocol(model.applicationProtocol);
            this.clientCertificateConfig(model.clientCertificateConfig);
        }

        public final String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getServerCertificateArns() {
            if (this.serverCertificateArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serverCertificateArns;
        }

        public final void setServerCertificateArns(Collection<String> serverCertificateArns) {
            this.serverCertificateArns = ServerCertificateArnsCopier.copy(serverCertificateArns);
        }

        @Override
        public final Builder serverCertificateArns(Collection<String> serverCertificateArns) {
            this.serverCertificateArns = ServerCertificateArnsCopier.copy(serverCertificateArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificateArns(String ... serverCertificateArns) {
            this.serverCertificateArns(Arrays.asList(serverCertificateArns));
            return this;
        }

        public final String getValidationCertificateArn() {
            return this.validationCertificateArn;
        }

        public final void setValidationCertificateArn(String validationCertificateArn) {
            this.validationCertificateArn = validationCertificateArn;
        }

        @Override
        public final Builder validationCertificateArn(String validationCertificateArn) {
            this.validationCertificateArn = validationCertificateArn;
            return this;
        }

        public final AuthorizerConfig.Builder getAuthorizerConfig() {
            return this.authorizerConfig != null ? this.authorizerConfig.toBuilder() : null;
        }

        public final void setAuthorizerConfig(AuthorizerConfig.BuilderImpl authorizerConfig) {
            this.authorizerConfig = authorizerConfig != null ? authorizerConfig.build() : null;
        }

        @Override
        public final Builder authorizerConfig(AuthorizerConfig authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TlsConfig.Builder getTlsConfig() {
            return this.tlsConfig != null ? this.tlsConfig.toBuilder() : null;
        }

        public final void setTlsConfig(TlsConfig.BuilderImpl tlsConfig) {
            this.tlsConfig = tlsConfig != null ? tlsConfig.build() : null;
        }

        @Override
        public final Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public final ServerCertificateConfig.Builder getServerCertificateConfig() {
            return this.serverCertificateConfig != null ? this.serverCertificateConfig.toBuilder() : null;
        }

        public final void setServerCertificateConfig(ServerCertificateConfig.BuilderImpl serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig != null ? serverCertificateConfig.build() : null;
        }

        @Override
        public final Builder serverCertificateConfig(ServerCertificateConfig serverCertificateConfig) {
            this.serverCertificateConfig = serverCertificateConfig;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getApplicationProtocol() {
            return this.applicationProtocol;
        }

        public final void setApplicationProtocol(String applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
        }

        @Override
        public final Builder applicationProtocol(String applicationProtocol) {
            this.applicationProtocol = applicationProtocol;
            return this;
        }

        @Override
        public final Builder applicationProtocol(ApplicationProtocol applicationProtocol) {
            this.applicationProtocol(applicationProtocol == null ? null : applicationProtocol.toString());
            return this;
        }

        public final ClientCertificateConfig.Builder getClientCertificateConfig() {
            return this.clientCertificateConfig != null ? this.clientCertificateConfig.toBuilder() : null;
        }

        public final void setClientCertificateConfig(ClientCertificateConfig.BuilderImpl clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig != null ? clientCertificateConfig.build() : null;
        }

        @Override
        public final Builder clientCertificateConfig(ClientCertificateConfig clientCertificateConfig) {
            this.clientCertificateConfig = clientCertificateConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainConfigurationRequest build() {
            return new CreateDomainConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainConfigurationRequest> {
        public Builder domainConfigurationName(String var1);

        public Builder domainName(String var1);

        public Builder serverCertificateArns(Collection<String> var1);

        public Builder serverCertificateArns(String ... var1);

        public Builder validationCertificateArn(String var1);

        public Builder authorizerConfig(AuthorizerConfig var1);

        default public Builder authorizerConfig(Consumer<AuthorizerConfig.Builder> authorizerConfig) {
            return this.authorizerConfig((AuthorizerConfig)((AuthorizerConfig.Builder)AuthorizerConfig.builder().applyMutation(authorizerConfig)).build());
        }

        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder tlsConfig(TlsConfig var1);

        default public Builder tlsConfig(Consumer<TlsConfig.Builder> tlsConfig) {
            return this.tlsConfig((TlsConfig)((TlsConfig.Builder)TlsConfig.builder().applyMutation(tlsConfig)).build());
        }

        public Builder serverCertificateConfig(ServerCertificateConfig var1);

        default public Builder serverCertificateConfig(Consumer<ServerCertificateConfig.Builder> serverCertificateConfig) {
            return this.serverCertificateConfig((ServerCertificateConfig)((ServerCertificateConfig.Builder)ServerCertificateConfig.builder().applyMutation(serverCertificateConfig)).build());
        }

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder applicationProtocol(String var1);

        public Builder applicationProtocol(ApplicationProtocol var1);

        public Builder clientCertificateConfig(ClientCertificateConfig var1);

        default public Builder clientCertificateConfig(Consumer<ClientCertificateConfig.Builder> clientCertificateConfig) {
            return this.clientCertificateConfig((ClientCertificateConfig)((ClientCertificateConfig.Builder)ClientCertificateConfig.builder().applyMutation(clientCertificateConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

