/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AutoRegistrationStatus;
import software.amazon.awssdk.services.iot.model.CACertificateStatus;
import software.amazon.awssdk.services.iot.model.CertificateMode;
import software.amazon.awssdk.services.iot.model.CertificateValidity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CACertificateDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CACertificateDescription> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateArn").getter(CACertificateDescription.getter(CACertificateDescription::certificateArn)).setter(CACertificateDescription.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateId").getter(CACertificateDescription.getter(CACertificateDescription::certificateId)).setter(CACertificateDescription.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CACertificateDescription.getter(CACertificateDescription::statusAsString)).setter(CACertificateDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificatePem").getter(CACertificateDescription.getter(CACertificateDescription::certificatePem)).setter(CACertificateDescription.setter(Builder::certificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()}).build();
    private static final SdkField<String> OWNED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownedBy").getter(CACertificateDescription.getter(CACertificateDescription::ownedBy)).setter(CACertificateDescription.setter(Builder::ownedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownedBy").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(CACertificateDescription.getter(CACertificateDescription::creationDate)).setter(CACertificateDescription.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> AUTO_REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoRegistrationStatus").getter(CACertificateDescription.getter(CACertificateDescription::autoRegistrationStatusAsString)).setter(CACertificateDescription.setter(Builder::autoRegistrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRegistrationStatus").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(CACertificateDescription.getter(CACertificateDescription::lastModifiedDate)).setter(CACertificateDescription.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<Integer> CUSTOMER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("customerVersion").getter(CACertificateDescription.getter(CACertificateDescription::customerVersion)).setter(CACertificateDescription.setter(Builder::customerVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerVersion").build()}).build();
    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationId").getter(CACertificateDescription.getter(CACertificateDescription::generationId)).setter(CACertificateDescription.setter(Builder::generationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()}).build();
    private static final SdkField<CertificateValidity> VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validity").getter(CACertificateDescription.getter(CACertificateDescription::validity)).setter(CACertificateDescription.setter(Builder::validity)).constructor(CertificateValidity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validity").build()}).build();
    private static final SdkField<String> CERTIFICATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateMode").getter(CACertificateDescription.getter(CACertificateDescription::certificateModeAsString)).setter(CACertificateDescription.setter(Builder::certificateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, CERTIFICATE_ID_FIELD, STATUS_FIELD, CERTIFICATE_PEM_FIELD, OWNED_BY_FIELD, CREATION_DATE_FIELD, AUTO_REGISTRATION_STATUS_FIELD, LAST_MODIFIED_DATE_FIELD, CUSTOMER_VERSION_FIELD, GENERATION_ID_FIELD, VALIDITY_FIELD, CERTIFICATE_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CACertificateDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final String certificateId;
    private final String status;
    private final String certificatePem;
    private final String ownedBy;
    private final Instant creationDate;
    private final String autoRegistrationStatus;
    private final Instant lastModifiedDate;
    private final Integer customerVersion;
    private final String generationId;
    private final CertificateValidity validity;
    private final String certificateMode;

    private CACertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.creationDate = builder.creationDate;
        this.autoRegistrationStatus = builder.autoRegistrationStatus;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.customerVersion = builder.customerVersion;
        this.generationId = builder.generationId;
        this.validity = builder.validity;
        this.certificateMode = builder.certificateMode;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final String certificateId() {
        return this.certificateId;
    }

    public final CACertificateStatus status() {
        return CACertificateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String certificatePem() {
        return this.certificatePem;
    }

    public final String ownedBy() {
        return this.ownedBy;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final AutoRegistrationStatus autoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(this.autoRegistrationStatus);
    }

    public final String autoRegistrationStatusAsString() {
        return this.autoRegistrationStatus;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final Integer customerVersion() {
        return this.customerVersion;
    }

    public final String generationId() {
        return this.generationId;
    }

    public final CertificateValidity validity() {
        return this.validity;
    }

    public final CertificateMode certificateMode() {
        return CertificateMode.fromValue(this.certificateMode);
    }

    public final String certificateModeAsString() {
        return this.certificateMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRegistrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CACertificateDescription)) {
            return false;
        }
        CACertificateDescription other = (CACertificateDescription)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.ownedBy(), other.ownedBy()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.autoRegistrationStatusAsString(), other.autoRegistrationStatusAsString()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.customerVersion(), other.customerVersion()) && Objects.equals(this.generationId(), other.generationId()) && Objects.equals(this.validity(), other.validity()) && Objects.equals(this.certificateModeAsString(), other.certificateModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CACertificateDescription").add("CertificateArn", (Object)this.certificateArn()).add("CertificateId", (Object)this.certificateId()).add("Status", (Object)this.statusAsString()).add("CertificatePem", (Object)this.certificatePem()).add("OwnedBy", (Object)this.ownedBy()).add("CreationDate", (Object)this.creationDate()).add("AutoRegistrationStatus", (Object)this.autoRegistrationStatusAsString()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CustomerVersion", (Object)this.customerVersion()).add("GenerationId", (Object)this.generationId()).add("Validity", (Object)this.validity()).add("CertificateMode", (Object)this.certificateModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "ownedBy": {
                return Optional.ofNullable(clazz.cast(this.ownedBy()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "autoRegistrationStatus": {
                return Optional.ofNullable(clazz.cast(this.autoRegistrationStatusAsString()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "customerVersion": {
                return Optional.ofNullable(clazz.cast(this.customerVersion()));
            }
            case "generationId": {
                return Optional.ofNullable(clazz.cast(this.generationId()));
            }
            case "validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
            case "certificateMode": {
                return Optional.ofNullable(clazz.cast(this.certificateModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("certificateArn", CERTIFICATE_ARN_FIELD);
        map.put("certificateId", CERTIFICATE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("certificatePem", CERTIFICATE_PEM_FIELD);
        map.put("ownedBy", OWNED_BY_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("autoRegistrationStatus", AUTO_REGISTRATION_STATUS_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("customerVersion", CUSTOMER_VERSION_FIELD);
        map.put("generationId", GENERATION_ID_FIELD);
        map.put("validity", VALIDITY_FIELD);
        map.put("certificateMode", CERTIFICATE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CACertificateDescription, T> g) {
        return obj -> g.apply((CACertificateDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String status;
        private String certificatePem;
        private String ownedBy;
        private Instant creationDate;
        private String autoRegistrationStatus;
        private Instant lastModifiedDate;
        private Integer customerVersion;
        private String generationId;
        private CertificateValidity validity;
        private String certificateMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CACertificateDescription model) {
            this.certificateArn(model.certificateArn);
            this.certificateId(model.certificateId);
            this.status(model.status);
            this.certificatePem(model.certificatePem);
            this.ownedBy(model.ownedBy);
            this.creationDate(model.creationDate);
            this.autoRegistrationStatus(model.autoRegistrationStatus);
            this.lastModifiedDate(model.lastModifiedDate);
            this.customerVersion(model.customerVersion);
            this.generationId(model.generationId);
            this.validity(model.validity);
            this.certificateMode(model.certificateMode);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CACertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final String getOwnedBy() {
            return this.ownedBy;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getAutoRegistrationStatus() {
            return this.autoRegistrationStatus;
        }

        public final void setAutoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
        }

        @Override
        public final Builder autoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus) {
            this.autoRegistrationStatus(autoRegistrationStatus == null ? null : autoRegistrationStatus.toString());
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Integer getCustomerVersion() {
            return this.customerVersion;
        }

        public final void setCustomerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
        }

        @Override
        public final Builder customerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
            return this;
        }

        public final String getGenerationId() {
            return this.generationId;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final CertificateValidity.Builder getValidity() {
            return this.validity != null ? this.validity.toBuilder() : null;
        }

        public final void setValidity(CertificateValidity.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        @Override
        public final Builder validity(CertificateValidity validity) {
            this.validity = validity;
            return this;
        }

        public final String getCertificateMode() {
            return this.certificateMode;
        }

        public final void setCertificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
        }

        @Override
        public final Builder certificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
            return this;
        }

        @Override
        public final Builder certificateMode(CertificateMode certificateMode) {
            this.certificateMode(certificateMode == null ? null : certificateMode.toString());
            return this;
        }

        public CACertificateDescription build() {
            return new CACertificateDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CACertificateDescription> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder status(String var1);

        public Builder status(CACertificateStatus var1);

        public Builder certificatePem(String var1);

        public Builder ownedBy(String var1);

        public Builder creationDate(Instant var1);

        public Builder autoRegistrationStatus(String var1);

        public Builder autoRegistrationStatus(AutoRegistrationStatus var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder customerVersion(Integer var1);

        public Builder generationId(String var1);

        public Builder validity(CertificateValidity var1);

        default public Builder validity(Consumer<CertificateValidity.Builder> validity) {
            return this.validity((CertificateValidity)((CertificateValidity.Builder)CertificateValidity.builder().applyMutation(validity)).build());
        }

        public Builder certificateMode(String var1);

        public Builder certificateMode(CertificateMode var1);
    }
}

