/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.BehaviorCriteria;
import software.amazon.awssdk.services.iot.model.MetricDimension;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Behavior
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Behavior> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Behavior.getter(Behavior::name)).setter(Behavior.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metric").getter(Behavior.getter(Behavior::metric)).setter(Behavior.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metric").build()}).build();
    private static final SdkField<MetricDimension> METRIC_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metricDimension").getter(Behavior.getter(Behavior::metricDimension)).setter(Behavior.setter(Builder::metricDimension)).constructor(MetricDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDimension").build()}).build();
    private static final SdkField<BehaviorCriteria> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("criteria").getter(Behavior.getter(Behavior::criteria)).setter(Behavior.setter(Builder::criteria)).constructor(BehaviorCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteria").build()}).build();
    private static final SdkField<Boolean> SUPPRESS_ALERTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("suppressAlerts").getter(Behavior.getter(Behavior::suppressAlerts)).setter(Behavior.setter(Builder::suppressAlerts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressAlerts").build()}).build();
    private static final SdkField<Boolean> EXPORT_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("exportMetric").getter(Behavior.getter(Behavior::exportMetric)).setter(Behavior.setter(Builder::exportMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportMetric").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, METRIC_FIELD, METRIC_DIMENSION_FIELD, CRITERIA_FIELD, SUPPRESS_ALERTS_FIELD, EXPORT_METRIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Behavior.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String metric;
    private final MetricDimension metricDimension;
    private final BehaviorCriteria criteria;
    private final Boolean suppressAlerts;
    private final Boolean exportMetric;

    private Behavior(BuilderImpl builder) {
        this.name = builder.name;
        this.metric = builder.metric;
        this.metricDimension = builder.metricDimension;
        this.criteria = builder.criteria;
        this.suppressAlerts = builder.suppressAlerts;
        this.exportMetric = builder.exportMetric;
    }

    public final String name() {
        return this.name;
    }

    public final String metric() {
        return this.metric;
    }

    public final MetricDimension metricDimension() {
        return this.metricDimension;
    }

    public final BehaviorCriteria criteria() {
        return this.criteria;
    }

    public final Boolean suppressAlerts() {
        return this.suppressAlerts;
    }

    public final Boolean exportMetric() {
        return this.exportMetric;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressAlerts());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportMetric());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Behavior)) {
            return false;
        }
        Behavior other = (Behavior)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.metric(), other.metric()) && Objects.equals(this.metricDimension(), other.metricDimension()) && Objects.equals(this.criteria(), other.criteria()) && Objects.equals(this.suppressAlerts(), other.suppressAlerts()) && Objects.equals(this.exportMetric(), other.exportMetric());
    }

    public final String toString() {
        return ToString.builder((String)"Behavior").add("Name", (Object)this.name()).add("Metric", (Object)this.metric()).add("MetricDimension", (Object)this.metricDimension()).add("Criteria", (Object)this.criteria()).add("SuppressAlerts", (Object)this.suppressAlerts()).add("ExportMetric", (Object)this.exportMetric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "metricDimension": {
                return Optional.ofNullable(clazz.cast(this.metricDimension()));
            }
            case "criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "suppressAlerts": {
                return Optional.ofNullable(clazz.cast(this.suppressAlerts()));
            }
            case "exportMetric": {
                return Optional.ofNullable(clazz.cast(this.exportMetric()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("metric", METRIC_FIELD);
        map.put("metricDimension", METRIC_DIMENSION_FIELD);
        map.put("criteria", CRITERIA_FIELD);
        map.put("suppressAlerts", SUPPRESS_ALERTS_FIELD);
        map.put("exportMetric", EXPORT_METRIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Behavior, T> g) {
        return obj -> g.apply((Behavior)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String metric;
        private MetricDimension metricDimension;
        private BehaviorCriteria criteria;
        private Boolean suppressAlerts;
        private Boolean exportMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(Behavior model) {
            this.name(model.name);
            this.metric(model.metric);
            this.metricDimension(model.metricDimension);
            this.criteria(model.criteria);
            this.suppressAlerts(model.suppressAlerts);
            this.exportMetric(model.exportMetric);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final MetricDimension.Builder getMetricDimension() {
            return this.metricDimension != null ? this.metricDimension.toBuilder() : null;
        }

        public final void setMetricDimension(MetricDimension.BuilderImpl metricDimension) {
            this.metricDimension = metricDimension != null ? metricDimension.build() : null;
        }

        @Override
        public final Builder metricDimension(MetricDimension metricDimension) {
            this.metricDimension = metricDimension;
            return this;
        }

        public final BehaviorCriteria.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        public final void setCriteria(BehaviorCriteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(BehaviorCriteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final Boolean getSuppressAlerts() {
            return this.suppressAlerts;
        }

        public final void setSuppressAlerts(Boolean suppressAlerts) {
            this.suppressAlerts = suppressAlerts;
        }

        @Override
        public final Builder suppressAlerts(Boolean suppressAlerts) {
            this.suppressAlerts = suppressAlerts;
            return this;
        }

        public final Boolean getExportMetric() {
            return this.exportMetric;
        }

        public final void setExportMetric(Boolean exportMetric) {
            this.exportMetric = exportMetric;
        }

        @Override
        public final Builder exportMetric(Boolean exportMetric) {
            this.exportMetric = exportMetric;
            return this;
        }

        public Behavior build() {
            return new Behavior(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Behavior> {
        public Builder name(String var1);

        public Builder metric(String var1);

        public Builder metricDimension(MetricDimension var1);

        default public Builder metricDimension(Consumer<MetricDimension.Builder> metricDimension) {
            return this.metricDimension((MetricDimension)((MetricDimension.Builder)MetricDimension.builder().applyMutation(metricDimension)).build());
        }

        public Builder criteria(BehaviorCriteria var1);

        default public Builder criteria(Consumer<BehaviorCriteria.Builder> criteria) {
            return this.criteria((BehaviorCriteria)((BehaviorCriteria.Builder)BehaviorCriteria.builder().applyMutation(criteria)).build());
        }

        public Builder suppressAlerts(Boolean var1);

        public Builder exportMetric(Boolean var1);
    }
}

