/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudwatchLogsAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudwatchLogsAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CloudwatchLogsAction.getter(CloudwatchLogsAction::roleArn)).setter(CloudwatchLogsAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(CloudwatchLogsAction.getter(CloudwatchLogsAction::logGroupName)).setter(CloudwatchLogsAction.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<Boolean> BATCH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("batchMode").getter(CloudwatchLogsAction.getter(CloudwatchLogsAction::batchMode)).setter(CloudwatchLogsAction.setter(Builder::batchMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, LOG_GROUP_NAME_FIELD, BATCH_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudwatchLogsAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String logGroupName;
    private final Boolean batchMode;

    private CloudwatchLogsAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.logGroupName = builder.logGroupName;
        this.batchMode = builder.batchMode;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final Boolean batchMode() {
        return this.batchMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchMode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchLogsAction)) {
            return false;
        }
        CloudwatchLogsAction other = (CloudwatchLogsAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.batchMode(), other.batchMode());
    }

    public final String toString() {
        return ToString.builder((String)"CloudwatchLogsAction").add("RoleArn", (Object)this.roleArn()).add("LogGroupName", (Object)this.logGroupName()).add("BatchMode", (Object)this.batchMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "batchMode": {
                return Optional.ofNullable(clazz.cast(this.batchMode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        map.put("batchMode", BATCH_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudwatchLogsAction, T> g) {
        return obj -> g.apply((CloudwatchLogsAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String logGroupName;
        private Boolean batchMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchLogsAction model) {
            this.roleArn(model.roleArn);
            this.logGroupName(model.logGroupName);
            this.batchMode(model.batchMode);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Boolean getBatchMode() {
            return this.batchMode;
        }

        public final void setBatchMode(Boolean batchMode) {
            this.batchMode = batchMode;
        }

        @Override
        public final Builder batchMode(Boolean batchMode) {
            this.batchMode = batchMode;
            return this;
        }

        public CloudwatchLogsAction build() {
            return new CloudwatchLogsAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudwatchLogsAction> {
        public Builder roleArn(String var1);

        public Builder logGroupName(String var1);

        public Builder batchMode(Boolean var1);
    }
}

