/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuditCheckToActionsMappingCopier;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskStatisticsCopier;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskStatus;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskTarget;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.MitigationAction;
import software.amazon.awssdk.services.iot.model.MitigationActionListCopier;
import software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAuditMitigationActionsTaskResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeAuditMitigationActionsTaskResponse> {
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskStatus").getter(DescribeAuditMitigationActionsTaskResponse.getter(DescribeAuditMitigationActionsTaskResponse::taskStatusAsString)).setter(DescribeAuditMitigationActionsTaskResponse.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(DescribeAuditMitigationActionsTaskResponse.getter(DescribeAuditMitigationActionsTaskResponse::startTime)).setter(DescribeAuditMitigationActionsTaskResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(DescribeAuditMitigationActionsTaskResponse.getter(DescribeAuditMitigationActionsTaskResponse::endTime)).setter(DescribeAuditMitigationActionsTaskResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Map<String, TaskStatisticsForAuditCheck>> TASK_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("taskStatistics").getter(DescribeAuditMitigationActionsTaskResponse.getter(DescribeAuditMitigationActionsTaskResponse::taskStatistics)).setter(DescribeAuditMitigationActionsTaskResponse.setter(Builder::taskStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatistics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskStatisticsForAuditCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuditMitigationActionsTaskTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(DescribeAuditMitigationActionsTaskResponse.getter(DescribeAuditMitigationActionsTaskResponse::target)).setter(DescribeAuditMitigationActionsTaskResponse.setter(Builder::target)).constructor(AuditMitigationActionsTaskTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<Map<String, List<String>>> AUDIT_CHECK_TO_ACTIONS_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("auditCheckToActionsMapping").getter(DescribeAuditMitigationActionsTaskResponse.getter(DescribeAuditMitigationActionsTaskResponse::auditCheckToActionsMapping)).setter(DescribeAuditMitigationActionsTaskResponse.setter(Builder::auditCheckToActionsMapping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditCheckToActionsMapping").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<MitigationAction>> ACTIONS_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionsDefinition").getter(DescribeAuditMitigationActionsTaskResponse.getter(DescribeAuditMitigationActionsTaskResponse::actionsDefinition)).setter(DescribeAuditMitigationActionsTaskResponse.setter(Builder::actionsDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsDefinition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MitigationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, TASK_STATISTICS_FIELD, TARGET_FIELD, AUDIT_CHECK_TO_ACTIONS_MAPPING_FIELD, ACTIONS_DEFINITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAuditMitigationActionsTaskResponse.memberNameToFieldInitializer();
    private final String taskStatus;
    private final Instant startTime;
    private final Instant endTime;
    private final Map<String, TaskStatisticsForAuditCheck> taskStatistics;
    private final AuditMitigationActionsTaskTarget target;
    private final Map<String, List<String>> auditCheckToActionsMapping;
    private final List<MitigationAction> actionsDefinition;

    private DescribeAuditMitigationActionsTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskStatus = builder.taskStatus;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.taskStatistics = builder.taskStatistics;
        this.target = builder.target;
        this.auditCheckToActionsMapping = builder.auditCheckToActionsMapping;
        this.actionsDefinition = builder.actionsDefinition;
    }

    public final AuditMitigationActionsTaskStatus taskStatus() {
        return AuditMitigationActionsTaskStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasTaskStatistics() {
        return this.taskStatistics != null && !(this.taskStatistics instanceof SdkAutoConstructMap);
    }

    public final Map<String, TaskStatisticsForAuditCheck> taskStatistics() {
        return this.taskStatistics;
    }

    public final AuditMitigationActionsTaskTarget target() {
        return this.target;
    }

    public final boolean hasAuditCheckToActionsMapping() {
        return this.auditCheckToActionsMapping != null && !(this.auditCheckToActionsMapping instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> auditCheckToActionsMapping() {
        return this.auditCheckToActionsMapping;
    }

    public final boolean hasActionsDefinition() {
        return this.actionsDefinition != null && !(this.actionsDefinition instanceof SdkAutoConstructList);
    }

    public final List<MitigationAction> actionsDefinition() {
        return this.actionsDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskStatistics() ? this.taskStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuditCheckToActionsMapping() ? this.auditCheckToActionsMapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionsDefinition() ? this.actionsDefinition() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuditMitigationActionsTaskResponse)) {
            return false;
        }
        DescribeAuditMitigationActionsTaskResponse other = (DescribeAuditMitigationActionsTaskResponse)((Object)obj);
        return Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasTaskStatistics() == other.hasTaskStatistics() && Objects.equals(this.taskStatistics(), other.taskStatistics()) && Objects.equals(this.target(), other.target()) && this.hasAuditCheckToActionsMapping() == other.hasAuditCheckToActionsMapping() && Objects.equals(this.auditCheckToActionsMapping(), other.auditCheckToActionsMapping()) && this.hasActionsDefinition() == other.hasActionsDefinition() && Objects.equals(this.actionsDefinition(), other.actionsDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAuditMitigationActionsTaskResponse").add("TaskStatus", (Object)this.taskStatusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("TaskStatistics", this.hasTaskStatistics() ? this.taskStatistics() : null).add("Target", (Object)this.target()).add("AuditCheckToActionsMapping", this.hasAuditCheckToActionsMapping() ? this.auditCheckToActionsMapping() : null).add("ActionsDefinition", this.hasActionsDefinition() ? this.actionsDefinition() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "taskStatistics": {
                return Optional.ofNullable(clazz.cast(this.taskStatistics()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "auditCheckToActionsMapping": {
                return Optional.ofNullable(clazz.cast(this.auditCheckToActionsMapping()));
            }
            case "actionsDefinition": {
                return Optional.ofNullable(clazz.cast(this.actionsDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskStatus", TASK_STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("taskStatistics", TASK_STATISTICS_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("auditCheckToActionsMapping", AUDIT_CHECK_TO_ACTIONS_MAPPING_FIELD);
        map.put("actionsDefinition", ACTIONS_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAuditMitigationActionsTaskResponse, T> g) {
        return obj -> g.apply((DescribeAuditMitigationActionsTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String taskStatus;
        private Instant startTime;
        private Instant endTime;
        private Map<String, TaskStatisticsForAuditCheck> taskStatistics = DefaultSdkAutoConstructMap.getInstance();
        private AuditMitigationActionsTaskTarget target;
        private Map<String, List<String>> auditCheckToActionsMapping = DefaultSdkAutoConstructMap.getInstance();
        private List<MitigationAction> actionsDefinition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuditMitigationActionsTaskResponse model) {
            super(model);
            this.taskStatus(model.taskStatus);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.taskStatistics(model.taskStatistics);
            this.target(model.target);
            this.auditCheckToActionsMapping(model.auditCheckToActionsMapping);
            this.actionsDefinition(model.actionsDefinition);
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(AuditMitigationActionsTaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Map<String, TaskStatisticsForAuditCheck.Builder> getTaskStatistics() {
            Map<String, TaskStatisticsForAuditCheck.Builder> result = AuditMitigationActionsTaskStatisticsCopier.copyToBuilder(this.taskStatistics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTaskStatistics(Map<String, TaskStatisticsForAuditCheck.BuilderImpl> taskStatistics) {
            this.taskStatistics = AuditMitigationActionsTaskStatisticsCopier.copyFromBuilder(taskStatistics);
        }

        @Override
        public final Builder taskStatistics(Map<String, TaskStatisticsForAuditCheck> taskStatistics) {
            this.taskStatistics = AuditMitigationActionsTaskStatisticsCopier.copy(taskStatistics);
            return this;
        }

        public final AuditMitigationActionsTaskTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(AuditMitigationActionsTaskTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(AuditMitigationActionsTaskTarget target) {
            this.target = target;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getAuditCheckToActionsMapping() {
            if (this.auditCheckToActionsMapping instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.auditCheckToActionsMapping;
        }

        public final void setAuditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping) {
            this.auditCheckToActionsMapping = AuditCheckToActionsMappingCopier.copy(auditCheckToActionsMapping);
        }

        @Override
        public final Builder auditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping) {
            this.auditCheckToActionsMapping = AuditCheckToActionsMappingCopier.copy(auditCheckToActionsMapping);
            return this;
        }

        public final List<MitigationAction.Builder> getActionsDefinition() {
            List<MitigationAction.Builder> result = MitigationActionListCopier.copyToBuilder(this.actionsDefinition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionsDefinition(Collection<MitigationAction.BuilderImpl> actionsDefinition) {
            this.actionsDefinition = MitigationActionListCopier.copyFromBuilder(actionsDefinition);
        }

        @Override
        public final Builder actionsDefinition(Collection<MitigationAction> actionsDefinition) {
            this.actionsDefinition = MitigationActionListCopier.copy(actionsDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsDefinition(MitigationAction ... actionsDefinition) {
            this.actionsDefinition(Arrays.asList(actionsDefinition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsDefinition(Consumer<MitigationAction.Builder> ... actionsDefinition) {
            this.actionsDefinition(Stream.of(actionsDefinition).map(c -> (MitigationAction)((MitigationAction.Builder)MitigationAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAuditMitigationActionsTaskResponse build() {
            return new DescribeAuditMitigationActionsTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAuditMitigationActionsTaskResponse> {
        public Builder taskStatus(String var1);

        public Builder taskStatus(AuditMitigationActionsTaskStatus var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder taskStatistics(Map<String, TaskStatisticsForAuditCheck> var1);

        public Builder target(AuditMitigationActionsTaskTarget var1);

        default public Builder target(Consumer<AuditMitigationActionsTaskTarget.Builder> target) {
            return this.target((AuditMitigationActionsTaskTarget)((AuditMitigationActionsTaskTarget.Builder)AuditMitigationActionsTaskTarget.builder().applyMutation(target)).build());
        }

        public Builder auditCheckToActionsMapping(Map<String, ? extends Collection<String>> var1);

        public Builder actionsDefinition(Collection<MitigationAction> var1);

        public Builder actionsDefinition(MitigationAction ... var1);

        public Builder actionsDefinition(Consumer<MitigationAction.Builder> ... var1);
    }
}

