/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListStreamsRequest;
import software.amazon.awssdk.services.iot.model.ListStreamsResponse;
import software.amazon.awssdk.services.iot.model.StreamSummary;

public class ListStreamsIterable
implements SdkIterable<ListStreamsResponse> {
    private final IotClient client;
    private final ListStreamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamsIterable(IotClient client, ListStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStreamsResponseFetcher();
    }

    public Iterator<ListStreamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StreamSummary> streams() {
        Function<ListStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streams() != null) {
                return response.streams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamsResponseFetcher
    implements SyncPageFetcher<ListStreamsResponse> {
        private ListStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamsResponse nextPage(ListStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamsIterable.this.client.listStreams(ListStreamsIterable.this.firstRequest);
            }
            return ListStreamsIterable.this.client.listStreams((ListStreamsRequest)((Object)ListStreamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

