/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ExponentialRolloutRate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionsRolloutConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobExecutionsRolloutConfig> {
    private static final SdkField<Integer> MAXIMUM_PER_MINUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumPerMinute").getter(JobExecutionsRolloutConfig.getter(JobExecutionsRolloutConfig::maximumPerMinute)).setter(JobExecutionsRolloutConfig.setter(Builder::maximumPerMinute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPerMinute").build()}).build();
    private static final SdkField<ExponentialRolloutRate> EXPONENTIAL_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exponentialRate").getter(JobExecutionsRolloutConfig.getter(JobExecutionsRolloutConfig::exponentialRate)).setter(JobExecutionsRolloutConfig.setter(Builder::exponentialRate)).constructor(ExponentialRolloutRate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exponentialRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_PER_MINUTE_FIELD, EXPONENTIAL_RATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobExecutionsRolloutConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maximumPerMinute;
    private final ExponentialRolloutRate exponentialRate;

    private JobExecutionsRolloutConfig(BuilderImpl builder) {
        this.maximumPerMinute = builder.maximumPerMinute;
        this.exponentialRate = builder.exponentialRate;
    }

    public final Integer maximumPerMinute() {
        return this.maximumPerMinute;
    }

    public final ExponentialRolloutRate exponentialRate() {
        return this.exponentialRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(this.exponentialRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionsRolloutConfig)) {
            return false;
        }
        JobExecutionsRolloutConfig other = (JobExecutionsRolloutConfig)obj;
        return Objects.equals(this.maximumPerMinute(), other.maximumPerMinute()) && Objects.equals(this.exponentialRate(), other.exponentialRate());
    }

    public final String toString() {
        return ToString.builder((String)"JobExecutionsRolloutConfig").add("MaximumPerMinute", (Object)this.maximumPerMinute()).add("ExponentialRate", (Object)this.exponentialRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maximumPerMinute": {
                return Optional.ofNullable(clazz.cast(this.maximumPerMinute()));
            }
            case "exponentialRate": {
                return Optional.ofNullable(clazz.cast(this.exponentialRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maximumPerMinute", MAXIMUM_PER_MINUTE_FIELD);
        map.put("exponentialRate", EXPONENTIAL_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionsRolloutConfig, T> g) {
        return obj -> g.apply((JobExecutionsRolloutConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumPerMinute;
        private ExponentialRolloutRate exponentialRate;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionsRolloutConfig model) {
            this.maximumPerMinute(model.maximumPerMinute);
            this.exponentialRate(model.exponentialRate);
        }

        public final Integer getMaximumPerMinute() {
            return this.maximumPerMinute;
        }

        public final void setMaximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
        }

        @Override
        public final Builder maximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
            return this;
        }

        public final ExponentialRolloutRate.Builder getExponentialRate() {
            return this.exponentialRate != null ? this.exponentialRate.toBuilder() : null;
        }

        public final void setExponentialRate(ExponentialRolloutRate.BuilderImpl exponentialRate) {
            this.exponentialRate = exponentialRate != null ? exponentialRate.build() : null;
        }

        @Override
        public final Builder exponentialRate(ExponentialRolloutRate exponentialRate) {
            this.exponentialRate = exponentialRate;
            return this;
        }

        public JobExecutionsRolloutConfig build() {
            return new JobExecutionsRolloutConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobExecutionsRolloutConfig> {
        public Builder maximumPerMinute(Integer var1);

        public Builder exponentialRate(ExponentialRolloutRate var1);

        default public Builder exponentialRate(Consumer<ExponentialRolloutRate.Builder> exponentialRate) {
            return this.exponentialRate((ExponentialRolloutRate)((ExponentialRolloutRate.Builder)ExponentialRolloutRate.builder().applyMutation(exponentialRate)).build());
        }
    }
}

