/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.Sbom;
import software.amazon.awssdk.services.iot.model.SbomValidationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSbomWithPackageVersionResponse
extends IotResponse
implements ToCopyableBuilder<Builder, AssociateSbomWithPackageVersionResponse> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(AssociateSbomWithPackageVersionResponse.getter(AssociateSbomWithPackageVersionResponse::packageName)).setter(AssociateSbomWithPackageVersionResponse.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(AssociateSbomWithPackageVersionResponse.getter(AssociateSbomWithPackageVersionResponse::versionName)).setter(AssociateSbomWithPackageVersionResponse.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<Sbom> SBOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sbom").getter(AssociateSbomWithPackageVersionResponse.getter(AssociateSbomWithPackageVersionResponse::sbom)).setter(AssociateSbomWithPackageVersionResponse.setter(Builder::sbom)).constructor(Sbom::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbom").build()}).build();
    private static final SdkField<String> SBOM_VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sbomValidationStatus").getter(AssociateSbomWithPackageVersionResponse.getter(AssociateSbomWithPackageVersionResponse::sbomValidationStatusAsString)).setter(AssociateSbomWithPackageVersionResponse.setter(Builder::sbomValidationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbomValidationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, VERSION_NAME_FIELD, SBOM_FIELD, SBOM_VALIDATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateSbomWithPackageVersionResponse.memberNameToFieldInitializer();
    private final String packageName;
    private final String versionName;
    private final Sbom sbom;
    private final String sbomValidationStatus;

    private AssociateSbomWithPackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.versionName = builder.versionName;
        this.sbom = builder.sbom;
        this.sbomValidationStatus = builder.sbomValidationStatus;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final Sbom sbom() {
        return this.sbom;
    }

    public final SbomValidationStatus sbomValidationStatus() {
        return SbomValidationStatus.fromValue(this.sbomValidationStatus);
    }

    public final String sbomValidationStatusAsString() {
        return this.sbomValidationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sbom());
        hashCode = 31 * hashCode + Objects.hashCode(this.sbomValidationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSbomWithPackageVersionResponse)) {
            return false;
        }
        AssociateSbomWithPackageVersionResponse other = (AssociateSbomWithPackageVersionResponse)((Object)obj);
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.sbom(), other.sbom()) && Objects.equals(this.sbomValidationStatusAsString(), other.sbomValidationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSbomWithPackageVersionResponse").add("PackageName", (Object)this.packageName()).add("VersionName", (Object)this.versionName()).add("Sbom", (Object)this.sbom()).add("SbomValidationStatus", (Object)this.sbomValidationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "sbom": {
                return Optional.ofNullable(clazz.cast(this.sbom()));
            }
            case "sbomValidationStatus": {
                return Optional.ofNullable(clazz.cast(this.sbomValidationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("sbom", SBOM_FIELD);
        map.put("sbomValidationStatus", SBOM_VALIDATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSbomWithPackageVersionResponse, T> g) {
        return obj -> g.apply((AssociateSbomWithPackageVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String packageName;
        private String versionName;
        private Sbom sbom;
        private String sbomValidationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSbomWithPackageVersionResponse model) {
            super(model);
            this.packageName(model.packageName);
            this.versionName(model.versionName);
            this.sbom(model.sbom);
            this.sbomValidationStatus(model.sbomValidationStatus);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final Sbom.Builder getSbom() {
            return this.sbom != null ? this.sbom.toBuilder() : null;
        }

        public final void setSbom(Sbom.BuilderImpl sbom) {
            this.sbom = sbom != null ? sbom.build() : null;
        }

        @Override
        public final Builder sbom(Sbom sbom) {
            this.sbom = sbom;
            return this;
        }

        public final String getSbomValidationStatus() {
            return this.sbomValidationStatus;
        }

        public final void setSbomValidationStatus(String sbomValidationStatus) {
            this.sbomValidationStatus = sbomValidationStatus;
        }

        @Override
        public final Builder sbomValidationStatus(String sbomValidationStatus) {
            this.sbomValidationStatus = sbomValidationStatus;
            return this;
        }

        @Override
        public final Builder sbomValidationStatus(SbomValidationStatus sbomValidationStatus) {
            this.sbomValidationStatus(sbomValidationStatus == null ? null : sbomValidationStatus.toString());
            return this;
        }

        @Override
        public AssociateSbomWithPackageVersionResponse build() {
            return new AssociateSbomWithPackageVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSbomWithPackageVersionResponse> {
        public Builder packageName(String var1);

        public Builder versionName(String var1);

        public Builder sbom(Sbom var1);

        default public Builder sbom(Consumer<Sbom.Builder> sbom) {
            return this.sbom((Sbom)((Sbom.Builder)Sbom.builder().applyMutation(sbom)).build());
        }

        public Builder sbomValidationStatus(String var1);

        public Builder sbomValidationStatus(SbomValidationStatus var1);
    }
}

