/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CommandNamespace;
import software.amazon.awssdk.services.iot.model.CommandParameter;
import software.amazon.awssdk.services.iot.model.CommandParameterListCopier;
import software.amazon.awssdk.services.iot.model.CommandPayload;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCommandResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetCommandResponse> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commandId").getter(GetCommandResponse.getter(GetCommandResponse::commandId)).setter(GetCommandResponse.setter(Builder::commandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandId").build()}).build();
    private static final SdkField<String> COMMAND_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commandArn").getter(GetCommandResponse.getter(GetCommandResponse::commandArn)).setter(GetCommandResponse.setter(Builder::commandArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandArn").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(GetCommandResponse.getter(GetCommandResponse::namespaceAsString)).setter(GetCommandResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetCommandResponse.getter(GetCommandResponse::displayName)).setter(GetCommandResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetCommandResponse.getter(GetCommandResponse::description)).setter(GetCommandResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<CommandParameter>> MANDATORY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mandatoryParameters").getter(GetCommandResponse.getter(GetCommandResponse::mandatoryParameters)).setter(GetCommandResponse.setter(Builder::mandatoryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mandatoryParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CommandPayload> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("payload").getter(GetCommandResponse.getter(GetCommandResponse::payload)).setter(GetCommandResponse.setter(Builder::payload)).constructor(CommandPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetCommandResponse.getter(GetCommandResponse::roleArn)).setter(GetCommandResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetCommandResponse.getter(GetCommandResponse::createdAt)).setter(GetCommandResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetCommandResponse.getter(GetCommandResponse::lastUpdatedAt)).setter(GetCommandResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Boolean> DEPRECATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deprecated").getter(GetCommandResponse.getter(GetCommandResponse::deprecated)).setter(GetCommandResponse.setter(Builder::deprecated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecated").build()}).build();
    private static final SdkField<Boolean> PENDING_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("pendingDeletion").getter(GetCommandResponse.getter(GetCommandResponse::pendingDeletion)).setter(GetCommandResponse.setter(Builder::pendingDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingDeletion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD, COMMAND_ARN_FIELD, NAMESPACE_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, MANDATORY_PARAMETERS_FIELD, PAYLOAD_FIELD, ROLE_ARN_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, DEPRECATED_FIELD, PENDING_DELETION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCommandResponse.memberNameToFieldInitializer();
    private final String commandId;
    private final String commandArn;
    private final String namespace;
    private final String displayName;
    private final String description;
    private final List<CommandParameter> mandatoryParameters;
    private final CommandPayload payload;
    private final String roleArn;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Boolean deprecated;
    private final Boolean pendingDeletion;

    private GetCommandResponse(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.commandArn = builder.commandArn;
        this.namespace = builder.namespace;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.mandatoryParameters = builder.mandatoryParameters;
        this.payload = builder.payload;
        this.roleArn = builder.roleArn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.deprecated = builder.deprecated;
        this.pendingDeletion = builder.pendingDeletion;
    }

    public final String commandId() {
        return this.commandId;
    }

    public final String commandArn() {
        return this.commandArn;
    }

    public final CommandNamespace namespace() {
        return CommandNamespace.fromValue(this.namespace);
    }

    public final String namespaceAsString() {
        return this.namespace;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMandatoryParameters() {
        return this.mandatoryParameters != null && !(this.mandatoryParameters instanceof SdkAutoConstructList);
    }

    public final List<CommandParameter> mandatoryParameters() {
        return this.mandatoryParameters;
    }

    public final CommandPayload payload() {
        return this.payload;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Boolean deprecated() {
        return this.deprecated;
    }

    public final Boolean pendingDeletion() {
        return this.pendingDeletion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commandArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMandatoryParameters() ? this.mandatoryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecated());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingDeletion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandResponse)) {
            return false;
        }
        GetCommandResponse other = (GetCommandResponse)((Object)obj);
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.commandArn(), other.commandArn()) && Objects.equals(this.namespaceAsString(), other.namespaceAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && this.hasMandatoryParameters() == other.hasMandatoryParameters() && Objects.equals(this.mandatoryParameters(), other.mandatoryParameters()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.deprecated(), other.deprecated()) && Objects.equals(this.pendingDeletion(), other.pendingDeletion());
    }

    public final String toString() {
        return ToString.builder((String)"GetCommandResponse").add("CommandId", (Object)this.commandId()).add("CommandArn", (Object)this.commandArn()).add("Namespace", (Object)this.namespaceAsString()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("MandatoryParameters", this.hasMandatoryParameters() ? this.mandatoryParameters() : null).add("Payload", (Object)this.payload()).add("RoleArn", (Object)this.roleArn()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Deprecated", (Object)this.deprecated()).add("PendingDeletion", (Object)this.pendingDeletion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commandId": {
                return Optional.ofNullable(clazz.cast(this.commandId()));
            }
            case "commandArn": {
                return Optional.ofNullable(clazz.cast(this.commandArn()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespaceAsString()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "mandatoryParameters": {
                return Optional.ofNullable(clazz.cast(this.mandatoryParameters()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "deprecated": {
                return Optional.ofNullable(clazz.cast(this.deprecated()));
            }
            case "pendingDeletion": {
                return Optional.ofNullable(clazz.cast(this.pendingDeletion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commandId", COMMAND_ID_FIELD);
        map.put("commandArn", COMMAND_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("mandatoryParameters", MANDATORY_PARAMETERS_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("deprecated", DEPRECATED_FIELD);
        map.put("pendingDeletion", PENDING_DELETION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommandResponse, T> g) {
        return obj -> g.apply((GetCommandResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String commandId;
        private String commandArn;
        private String namespace;
        private String displayName;
        private String description;
        private List<CommandParameter> mandatoryParameters = DefaultSdkAutoConstructList.getInstance();
        private CommandPayload payload;
        private String roleArn;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Boolean deprecated;
        private Boolean pendingDeletion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandResponse model) {
            super(model);
            this.commandId(model.commandId);
            this.commandArn(model.commandArn);
            this.namespace(model.namespace);
            this.displayName(model.displayName);
            this.description(model.description);
            this.mandatoryParameters(model.mandatoryParameters);
            this.payload(model.payload);
            this.roleArn(model.roleArn);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.deprecated(model.deprecated);
            this.pendingDeletion(model.pendingDeletion);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getCommandArn() {
            return this.commandArn;
        }

        public final void setCommandArn(String commandArn) {
            this.commandArn = commandArn;
        }

        @Override
        public final Builder commandArn(String commandArn) {
            this.commandArn = commandArn;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(CommandNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<CommandParameter.Builder> getMandatoryParameters() {
            List<CommandParameter.Builder> result = CommandParameterListCopier.copyToBuilder(this.mandatoryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMandatoryParameters(Collection<CommandParameter.BuilderImpl> mandatoryParameters) {
            this.mandatoryParameters = CommandParameterListCopier.copyFromBuilder(mandatoryParameters);
        }

        @Override
        public final Builder mandatoryParameters(Collection<CommandParameter> mandatoryParameters) {
            this.mandatoryParameters = CommandParameterListCopier.copy(mandatoryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mandatoryParameters(CommandParameter ... mandatoryParameters) {
            this.mandatoryParameters(Arrays.asList(mandatoryParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mandatoryParameters(Consumer<CommandParameter.Builder> ... mandatoryParameters) {
            this.mandatoryParameters(Stream.of(mandatoryParameters).map(c -> (CommandParameter)((CommandParameter.Builder)CommandParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CommandPayload.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        public final void setPayload(CommandPayload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(CommandPayload payload) {
            this.payload = payload;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Boolean getDeprecated() {
            return this.deprecated;
        }

        public final void setDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
        }

        @Override
        public final Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public final Boolean getPendingDeletion() {
            return this.pendingDeletion;
        }

        public final void setPendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
        }

        @Override
        public final Builder pendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
            return this;
        }

        @Override
        public GetCommandResponse build() {
            return new GetCommandResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCommandResponse> {
        public Builder commandId(String var1);

        public Builder commandArn(String var1);

        public Builder namespace(String var1);

        public Builder namespace(CommandNamespace var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder mandatoryParameters(Collection<CommandParameter> var1);

        public Builder mandatoryParameters(CommandParameter ... var1);

        public Builder mandatoryParameters(Consumer<CommandParameter.Builder> ... var1);

        public Builder payload(CommandPayload var1);

        default public Builder payload(Consumer<CommandPayload.Builder> payload) {
            return this.payload((CommandPayload)((CommandPayload.Builder)CommandPayload.builder().applyMutation(payload)).build());
        }

        public Builder roleArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder deprecated(Boolean var1);

        public Builder pendingDeletion(Boolean var1);
    }
}

