/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.MqttHeaders;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepublishAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepublishAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(RepublishAction.getter(RepublishAction::roleArn)).setter(RepublishAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("topic").getter(RepublishAction.getter(RepublishAction::topic)).setter(RepublishAction.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()}).build();
    private static final SdkField<Integer> QOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("qos").getter(RepublishAction.getter(RepublishAction::qos)).setter(RepublishAction.setter(Builder::qos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qos").build()}).build();
    private static final SdkField<MqttHeaders> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("headers").getter(RepublishAction.getter(RepublishAction::headers)).setter(RepublishAction.setter(Builder::headers)).constructor(MqttHeaders::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, TOPIC_FIELD, QOS_FIELD, HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RepublishAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String topic;
    private final Integer qos;
    private final MqttHeaders headers;

    private RepublishAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.topic = builder.topic;
        this.qos = builder.qos;
        this.headers = builder.headers;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String topic() {
        return this.topic;
    }

    public final Integer qos() {
        return this.qos;
    }

    public final MqttHeaders headers() {
        return this.headers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.qos());
        hashCode = 31 * hashCode + Objects.hashCode(this.headers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepublishAction)) {
            return false;
        }
        RepublishAction other = (RepublishAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.topic(), other.topic()) && Objects.equals(this.qos(), other.qos()) && Objects.equals(this.headers(), other.headers());
    }

    public final String toString() {
        return ToString.builder((String)"RepublishAction").add("RoleArn", (Object)this.roleArn()).add("Topic", (Object)this.topic()).add("Qos", (Object)this.qos()).add("Headers", (Object)this.headers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "qos": {
                return Optional.ofNullable(clazz.cast(this.qos()));
            }
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("topic", TOPIC_FIELD);
        map.put("qos", QOS_FIELD);
        map.put("headers", HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepublishAction, T> g) {
        return obj -> g.apply((RepublishAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String topic;
        private Integer qos;
        private MqttHeaders headers;

        private BuilderImpl() {
        }

        private BuilderImpl(RepublishAction model) {
            this.roleArn(model.roleArn);
            this.topic(model.topic);
            this.qos(model.qos);
            this.headers(model.headers);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTopic() {
            return this.topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final Integer getQos() {
            return this.qos;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final MqttHeaders.Builder getHeaders() {
            return this.headers != null ? this.headers.toBuilder() : null;
        }

        public final void setHeaders(MqttHeaders.BuilderImpl headers) {
            this.headers = headers != null ? headers.build() : null;
        }

        @Override
        public final Builder headers(MqttHeaders headers) {
            this.headers = headers;
            return this;
        }

        public RepublishAction build() {
            return new RepublishAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepublishAction> {
        public Builder roleArn(String var1);

        public Builder topic(String var1);

        public Builder qos(Integer var1);

        public Builder headers(MqttHeaders var1);

        default public Builder headers(Consumer<MqttHeaders.Builder> headers) {
            return this.headers((MqttHeaders)((MqttHeaders.Builder)MqttHeaders.builder().applyMutation(headers)).build());
        }
    }
}

