/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.Certificate;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaResponse;

public class ListCertificatesByCAPublisher
implements SdkPublisher<ListCertificatesByCaResponse> {
    private final IotAsyncClient client;
    private final ListCertificatesByCaRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCertificatesByCAPublisher(IotAsyncClient client, ListCertificatesByCaRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCertificatesByCAPublisher(IotAsyncClient client, ListCertificatesByCaRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCertificatesByCaResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCertificatesByCaResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Certificate> certificates() {
        Function<ListCertificatesByCaResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCertificatesByCaResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCertificatesByCaResponseFetcher
    implements AsyncPageFetcher<ListCertificatesByCaResponse> {
        private ListCertificatesByCaResponseFetcher() {
        }

        public boolean hasNextPage(ListCertificatesByCaResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListCertificatesByCaResponse> nextPage(ListCertificatesByCaResponse previousPage) {
            if (previousPage == null) {
                return ListCertificatesByCAPublisher.this.client.listCertificatesByCA(ListCertificatesByCAPublisher.this.firstRequest);
            }
            return ListCertificatesByCAPublisher.this.client.listCertificatesByCA((ListCertificatesByCaRequest)((Object)ListCertificatesByCAPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

