/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableIoTLoggingParams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnableIoTLoggingParams> {
    private static final SdkField<String> ROLE_ARN_FOR_LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArnForLogging").getter(EnableIoTLoggingParams.getter(EnableIoTLoggingParams::roleArnForLogging)).setter(EnableIoTLoggingParams.setter(Builder::roleArnForLogging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArnForLogging").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logLevel").getter(EnableIoTLoggingParams.getter(EnableIoTLoggingParams::logLevelAsString)).setter(EnableIoTLoggingParams.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FOR_LOGGING_FIELD, LOG_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableIoTLoggingParams.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArnForLogging;
    private final String logLevel;

    private EnableIoTLoggingParams(BuilderImpl builder) {
        this.roleArnForLogging = builder.roleArnForLogging;
        this.logLevel = builder.logLevel;
    }

    public final String roleArnForLogging() {
        return this.roleArnForLogging;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArnForLogging());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableIoTLoggingParams)) {
            return false;
        }
        EnableIoTLoggingParams other = (EnableIoTLoggingParams)obj;
        return Objects.equals(this.roleArnForLogging(), other.roleArnForLogging()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EnableIoTLoggingParams").add("RoleArnForLogging", (Object)this.roleArnForLogging()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArnForLogging": {
                return Optional.ofNullable(clazz.cast(this.roleArnForLogging()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("roleArnForLogging", ROLE_ARN_FOR_LOGGING_FIELD);
        map.put("logLevel", LOG_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableIoTLoggingParams, T> g) {
        return obj -> g.apply((EnableIoTLoggingParams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArnForLogging;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableIoTLoggingParams model) {
            this.roleArnForLogging(model.roleArnForLogging);
            this.logLevel(model.logLevel);
        }

        public final String getRoleArnForLogging() {
            return this.roleArnForLogging;
        }

        public final void setRoleArnForLogging(String roleArnForLogging) {
            this.roleArnForLogging = roleArnForLogging;
        }

        @Override
        public final Builder roleArnForLogging(String roleArnForLogging) {
            this.roleArnForLogging = roleArnForLogging;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public EnableIoTLoggingParams build() {
            return new EnableIoTLoggingParams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnableIoTLoggingParams> {
        public Builder roleArnForLogging(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);
    }
}

