/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeThingRegistrationTaskResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeThingRegistrationTaskResponse> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::taskId)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::creationDate)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::lastModifiedDate)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateBody").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::templateBody)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()}).build();
    private static final SdkField<String> INPUT_FILE_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputFileBucket").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::inputFileBucket)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::inputFileBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFileBucket").build()}).build();
    private static final SdkField<String> INPUT_FILE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputFileKey").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::inputFileKey)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::inputFileKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFileKey").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::roleArn)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::statusAsString)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::message)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Integer> SUCCESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("successCount").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::successCount)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::successCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successCount").build()}).build();
    private static final SdkField<Integer> FAILURE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failureCount").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::failureCount)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::failureCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCount").build()}).build();
    private static final SdkField<Integer> PERCENTAGE_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("percentageProgress").getter(DescribeThingRegistrationTaskResponse.getter(DescribeThingRegistrationTaskResponse::percentageProgress)).setter(DescribeThingRegistrationTaskResponse.setter(Builder::percentageProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentageProgress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, TEMPLATE_BODY_FIELD, INPUT_FILE_BUCKET_FIELD, INPUT_FILE_KEY_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, MESSAGE_FIELD, SUCCESS_COUNT_FIELD, FAILURE_COUNT_FIELD, PERCENTAGE_PROGRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeThingRegistrationTaskResponse.memberNameToFieldInitializer();
    private final String taskId;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final String templateBody;
    private final String inputFileBucket;
    private final String inputFileKey;
    private final String roleArn;
    private final String status;
    private final String message;
    private final Integer successCount;
    private final Integer failureCount;
    private final Integer percentageProgress;

    private DescribeThingRegistrationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.templateBody = builder.templateBody;
        this.inputFileBucket = builder.inputFileBucket;
        this.inputFileKey = builder.inputFileKey;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.message = builder.message;
        this.successCount = builder.successCount;
        this.failureCount = builder.failureCount;
        this.percentageProgress = builder.percentageProgress;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final String inputFileBucket() {
        return this.inputFileBucket;
    }

    public final String inputFileKey() {
        return this.inputFileKey;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Integer successCount() {
        return this.successCount;
    }

    public final Integer failureCount() {
        return this.failureCount;
    }

    public final Integer percentageProgress() {
        return this.percentageProgress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFileBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFileKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.successCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageProgress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingRegistrationTaskResponse)) {
            return false;
        }
        DescribeThingRegistrationTaskResponse other = (DescribeThingRegistrationTaskResponse)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.inputFileBucket(), other.inputFileBucket()) && Objects.equals(this.inputFileKey(), other.inputFileKey()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.successCount(), other.successCount()) && Objects.equals(this.failureCount(), other.failureCount()) && Objects.equals(this.percentageProgress(), other.percentageProgress());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeThingRegistrationTaskResponse").add("TaskId", (Object)this.taskId()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("TemplateBody", (Object)this.templateBody()).add("InputFileBucket", (Object)this.inputFileBucket()).add("InputFileKey", (Object)this.inputFileKey()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("SuccessCount", (Object)this.successCount()).add("FailureCount", (Object)this.failureCount()).add("PercentageProgress", (Object)this.percentageProgress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "templateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "inputFileBucket": {
                return Optional.ofNullable(clazz.cast(this.inputFileBucket()));
            }
            case "inputFileKey": {
                return Optional.ofNullable(clazz.cast(this.inputFileKey()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "successCount": {
                return Optional.ofNullable(clazz.cast(this.successCount()));
            }
            case "failureCount": {
                return Optional.ofNullable(clazz.cast(this.failureCount()));
            }
            case "percentageProgress": {
                return Optional.ofNullable(clazz.cast(this.percentageProgress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("templateBody", TEMPLATE_BODY_FIELD);
        map.put("inputFileBucket", INPUT_FILE_BUCKET_FIELD);
        map.put("inputFileKey", INPUT_FILE_KEY_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("successCount", SUCCESS_COUNT_FIELD);
        map.put("failureCount", FAILURE_COUNT_FIELD);
        map.put("percentageProgress", PERCENTAGE_PROGRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeThingRegistrationTaskResponse, T> g) {
        return obj -> g.apply((DescribeThingRegistrationTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String taskId;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private String templateBody;
        private String inputFileBucket;
        private String inputFileKey;
        private String roleArn;
        private String status;
        private String message;
        private Integer successCount;
        private Integer failureCount;
        private Integer percentageProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingRegistrationTaskResponse model) {
            super(model);
            this.taskId(model.taskId);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.templateBody(model.templateBody);
            this.inputFileBucket(model.inputFileBucket);
            this.inputFileKey(model.inputFileKey);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.message(model.message);
            this.successCount(model.successCount);
            this.failureCount(model.failureCount);
            this.percentageProgress(model.percentageProgress);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getInputFileBucket() {
            return this.inputFileBucket;
        }

        public final void setInputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
        }

        @Override
        public final Builder inputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
            return this;
        }

        public final String getInputFileKey() {
            return this.inputFileKey;
        }

        public final void setInputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
        }

        @Override
        public final Builder inputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Integer getSuccessCount() {
            return this.successCount;
        }

        public final void setSuccessCount(Integer successCount) {
            this.successCount = successCount;
        }

        @Override
        public final Builder successCount(Integer successCount) {
            this.successCount = successCount;
            return this;
        }

        public final Integer getFailureCount() {
            return this.failureCount;
        }

        public final void setFailureCount(Integer failureCount) {
            this.failureCount = failureCount;
        }

        @Override
        public final Builder failureCount(Integer failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        public final Integer getPercentageProgress() {
            return this.percentageProgress;
        }

        public final void setPercentageProgress(Integer percentageProgress) {
            this.percentageProgress = percentageProgress;
        }

        @Override
        public final Builder percentageProgress(Integer percentageProgress) {
            this.percentageProgress = percentageProgress;
            return this;
        }

        @Override
        public DescribeThingRegistrationTaskResponse build() {
            return new DescribeThingRegistrationTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeThingRegistrationTaskResponse> {
        public Builder taskId(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder templateBody(String var1);

        public Builder inputFileBucket(String var1);

        public Builder inputFileKey(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder message(String var1);

        public Builder successCount(Integer var1);

        public Builder failureCount(Integer var1);

        public Builder percentageProgress(Integer var1);
    }
}

