/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.BillingGroupProperties;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBillingGroupRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateBillingGroupRequest> {
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingGroupName").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::billingGroupName)).setter(CreateBillingGroupRequest.setter(Builder::billingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("billingGroupName").build()}).build();
    private static final SdkField<BillingGroupProperties> BILLING_GROUP_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("billingGroupProperties").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::billingGroupProperties)).setter(CreateBillingGroupRequest.setter(Builder::billingGroupProperties)).constructor(BillingGroupProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupProperties").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::tags)).setter(CreateBillingGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_NAME_FIELD, BILLING_GROUP_PROPERTIES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBillingGroupRequest.memberNameToFieldInitializer();
    private final String billingGroupName;
    private final BillingGroupProperties billingGroupProperties;
    private final List<Tag> tags;

    private CreateBillingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.billingGroupName = builder.billingGroupName;
        this.billingGroupProperties = builder.billingGroupProperties;
        this.tags = builder.tags;
    }

    public final String billingGroupName() {
        return this.billingGroupName;
    }

    public final BillingGroupProperties billingGroupProperties() {
        return this.billingGroupProperties;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBillingGroupRequest)) {
            return false;
        }
        CreateBillingGroupRequest other = (CreateBillingGroupRequest)((Object)obj);
        return Objects.equals(this.billingGroupName(), other.billingGroupName()) && Objects.equals(this.billingGroupProperties(), other.billingGroupProperties()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBillingGroupRequest").add("BillingGroupName", (Object)this.billingGroupName()).add("BillingGroupProperties", (Object)this.billingGroupProperties()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billingGroupName": {
                return Optional.ofNullable(clazz.cast(this.billingGroupName()));
            }
            case "billingGroupProperties": {
                return Optional.ofNullable(clazz.cast(this.billingGroupProperties()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billingGroupName", BILLING_GROUP_NAME_FIELD);
        map.put("billingGroupProperties", BILLING_GROUP_PROPERTIES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBillingGroupRequest, T> g) {
        return obj -> g.apply((CreateBillingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String billingGroupName;
        private BillingGroupProperties billingGroupProperties;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBillingGroupRequest model) {
            super(model);
            this.billingGroupName(model.billingGroupName);
            this.billingGroupProperties(model.billingGroupProperties);
            this.tags(model.tags);
        }

        public final String getBillingGroupName() {
            return this.billingGroupName;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        @Override
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final BillingGroupProperties.Builder getBillingGroupProperties() {
            return this.billingGroupProperties != null ? this.billingGroupProperties.toBuilder() : null;
        }

        public final void setBillingGroupProperties(BillingGroupProperties.BuilderImpl billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties != null ? billingGroupProperties.build() : null;
        }

        @Override
        public final Builder billingGroupProperties(BillingGroupProperties billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBillingGroupRequest build() {
            return new CreateBillingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBillingGroupRequest> {
        public Builder billingGroupName(String var1);

        public Builder billingGroupProperties(BillingGroupProperties var1);

        default public Builder billingGroupProperties(Consumer<BillingGroupProperties.Builder> billingGroupProperties) {
            return this.billingGroupProperties((BillingGroupProperties)((BillingGroupProperties.Builder)BillingGroupProperties.builder().applyMutation(billingGroupProperties)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

