/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.LocationTimestamp;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocationAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocationAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(LocationAction.getter(LocationAction::roleArn)).setter(LocationAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> TRACKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackerName").getter(LocationAction.getter(LocationAction::trackerName)).setter(LocationAction.setter(Builder::trackerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackerName").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceId").getter(LocationAction.getter(LocationAction::deviceId)).setter(LocationAction.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceId").build()}).build();
    private static final SdkField<LocationTimestamp> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timestamp").getter(LocationAction.getter(LocationAction::timestamp)).setter(LocationAction.setter(Builder::timestamp)).constructor(LocationTimestamp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> LATITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latitude").getter(LocationAction.getter(LocationAction::latitude)).setter(LocationAction.setter(Builder::latitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latitude").build()}).build();
    private static final SdkField<String> LONGITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("longitude").getter(LocationAction.getter(LocationAction::longitude)).setter(LocationAction.setter(Builder::longitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longitude").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, TRACKER_NAME_FIELD, DEVICE_ID_FIELD, TIMESTAMP_FIELD, LATITUDE_FIELD, LONGITUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LocationAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String trackerName;
    private final String deviceId;
    private final LocationTimestamp timestamp;
    private final String latitude;
    private final String longitude;

    private LocationAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.trackerName = builder.trackerName;
        this.deviceId = builder.deviceId;
        this.timestamp = builder.timestamp;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String trackerName() {
        return this.trackerName;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final LocationTimestamp timestamp() {
        return this.timestamp;
    }

    public final String latitude() {
        return this.latitude;
    }

    public final String longitude() {
        return this.longitude;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.latitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.longitude());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationAction)) {
            return false;
        }
        LocationAction other = (LocationAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.trackerName(), other.trackerName()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.latitude(), other.latitude()) && Objects.equals(this.longitude(), other.longitude());
    }

    public final String toString() {
        return ToString.builder((String)"LocationAction").add("RoleArn", (Object)this.roleArn()).add("TrackerName", (Object)this.trackerName()).add("DeviceId", (Object)this.deviceId()).add("Timestamp", (Object)this.timestamp()).add("Latitude", (Object)this.latitude()).add("Longitude", (Object)this.longitude()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "trackerName": {
                return Optional.ofNullable(clazz.cast(this.trackerName()));
            }
            case "deviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "latitude": {
                return Optional.ofNullable(clazz.cast(this.latitude()));
            }
            case "longitude": {
                return Optional.ofNullable(clazz.cast(this.longitude()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("trackerName", TRACKER_NAME_FIELD);
        map.put("deviceId", DEVICE_ID_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("latitude", LATITUDE_FIELD);
        map.put("longitude", LONGITUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocationAction, T> g) {
        return obj -> g.apply((LocationAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String trackerName;
        private String deviceId;
        private LocationTimestamp timestamp;
        private String latitude;
        private String longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationAction model) {
            this.roleArn(model.roleArn);
            this.trackerName(model.trackerName);
            this.deviceId(model.deviceId);
            this.timestamp(model.timestamp);
            this.latitude(model.latitude);
            this.longitude(model.longitude);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTrackerName() {
            return this.trackerName;
        }

        public final void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        @Override
        public final Builder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final LocationTimestamp.Builder getTimestamp() {
            return this.timestamp != null ? this.timestamp.toBuilder() : null;
        }

        public final void setTimestamp(LocationTimestamp.BuilderImpl timestamp) {
            this.timestamp = timestamp != null ? timestamp.build() : null;
        }

        @Override
        public final Builder timestamp(LocationTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getLatitude() {
            return this.latitude;
        }

        public final void setLatitude(String latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(String latitude) {
            this.latitude = latitude;
            return this;
        }

        public final String getLongitude() {
            return this.longitude;
        }

        public final void setLongitude(String longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(String longitude) {
            this.longitude = longitude;
            return this;
        }

        public LocationAction build() {
            return new LocationAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocationAction> {
        public Builder roleArn(String var1);

        public Builder trackerName(String var1);

        public Builder deviceId(String var1);

        public Builder timestamp(LocationTimestamp var1);

        default public Builder timestamp(Consumer<LocationTimestamp.Builder> timestamp) {
            return this.timestamp((LocationTimestamp)((LocationTimestamp.Builder)LocationTimestamp.builder().applyMutation(timestamp)).build());
        }

        public Builder latitude(String var1);

        public Builder longitude(String var1);
    }
}

