/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.FleetMetricNameAndArn;
import software.amazon.awssdk.services.iot.model.FleetMetricNameAndArnListCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFleetMetricsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListFleetMetricsResponse> {
    private static final SdkField<List<FleetMetricNameAndArn>> FLEET_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fleetMetrics").getter(ListFleetMetricsResponse.getter(ListFleetMetricsResponse::fleetMetrics)).setter(ListFleetMetricsResponse.setter(Builder::fleetMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetMetricNameAndArn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFleetMetricsResponse.getter(ListFleetMetricsResponse::nextToken)).setter(ListFleetMetricsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_METRICS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFleetMetricsResponse.memberNameToFieldInitializer();
    private final List<FleetMetricNameAndArn> fleetMetrics;
    private final String nextToken;

    private ListFleetMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetMetrics = builder.fleetMetrics;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFleetMetrics() {
        return this.fleetMetrics != null && !(this.fleetMetrics instanceof SdkAutoConstructList);
    }

    public final List<FleetMetricNameAndArn> fleetMetrics() {
        return this.fleetMetrics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetMetrics() ? this.fleetMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetMetricsResponse)) {
            return false;
        }
        ListFleetMetricsResponse other = (ListFleetMetricsResponse)((Object)obj);
        return this.hasFleetMetrics() == other.hasFleetMetrics() && Objects.equals(this.fleetMetrics(), other.fleetMetrics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFleetMetricsResponse").add("FleetMetrics", this.hasFleetMetrics() ? this.fleetMetrics() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fleetMetrics": {
                return Optional.ofNullable(clazz.cast(this.fleetMetrics()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fleetMetrics", FLEET_METRICS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFleetMetricsResponse, T> g) {
        return obj -> g.apply((ListFleetMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<FleetMetricNameAndArn> fleetMetrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetMetricsResponse model) {
            super(model);
            this.fleetMetrics(model.fleetMetrics);
            this.nextToken(model.nextToken);
        }

        public final List<FleetMetricNameAndArn.Builder> getFleetMetrics() {
            List<FleetMetricNameAndArn.Builder> result = FleetMetricNameAndArnListCopier.copyToBuilder(this.fleetMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetMetrics(Collection<FleetMetricNameAndArn.BuilderImpl> fleetMetrics) {
            this.fleetMetrics = FleetMetricNameAndArnListCopier.copyFromBuilder(fleetMetrics);
        }

        @Override
        public final Builder fleetMetrics(Collection<FleetMetricNameAndArn> fleetMetrics) {
            this.fleetMetrics = FleetMetricNameAndArnListCopier.copy(fleetMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetMetrics(FleetMetricNameAndArn ... fleetMetrics) {
            this.fleetMetrics(Arrays.asList(fleetMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetMetrics(Consumer<FleetMetricNameAndArn.Builder> ... fleetMetrics) {
            this.fleetMetrics(Stream.of(fleetMetrics).map(c -> (FleetMetricNameAndArn)((FleetMetricNameAndArn.Builder)FleetMetricNameAndArn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFleetMetricsResponse build() {
            return new ListFleetMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFleetMetricsResponse> {
        public Builder fleetMetrics(Collection<FleetMetricNameAndArn> var1);

        public Builder fleetMetrics(FleetMetricNameAndArn ... var1);

        public Builder fleetMetrics(Consumer<FleetMetricNameAndArn.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

