/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AbortConfig;
import software.amazon.awssdk.services.iot.model.DestinationPackageVersionsCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.JobExecutionsRetryConfig;
import software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig;
import software.amazon.awssdk.services.iot.model.MaintenanceWindow;
import software.amazon.awssdk.services.iot.model.MaintenanceWindowsCopier;
import software.amazon.awssdk.services.iot.model.PresignedUrlConfig;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.services.iot.model.TimeoutConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobTemplateRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateJobTemplateRequest> {
    private static final SdkField<String> JOB_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobTemplateId").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::jobTemplateId)).setter(CreateJobTemplateRequest.setter(Builder::jobTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobTemplateId").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::jobArn)).setter(CreateJobTemplateRequest.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> DOCUMENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentSource").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::documentSource)).setter(CreateJobTemplateRequest.setter(Builder::documentSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentSource").build()}).build();
    private static final SdkField<String> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("document").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::document)).setter(CreateJobTemplateRequest.setter(Builder::document)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::description)).setter(CreateJobTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<PresignedUrlConfig> PRESIGNED_URL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("presignedUrlConfig").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::presignedUrlConfig)).setter(CreateJobTemplateRequest.setter(Builder::presignedUrlConfig)).constructor(PresignedUrlConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlConfig").build()}).build();
    private static final SdkField<JobExecutionsRolloutConfig> JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobExecutionsRolloutConfig").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::jobExecutionsRolloutConfig)).setter(CreateJobTemplateRequest.setter(Builder::jobExecutionsRolloutConfig)).constructor(JobExecutionsRolloutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRolloutConfig").build()}).build();
    private static final SdkField<AbortConfig> ABORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("abortConfig").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::abortConfig)).setter(CreateJobTemplateRequest.setter(Builder::abortConfig)).constructor(AbortConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortConfig").build()}).build();
    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeoutConfig").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::timeoutConfig)).setter(CreateJobTemplateRequest.setter(Builder::timeoutConfig)).constructor(TimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::tags)).setter(CreateJobTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<JobExecutionsRetryConfig> JOB_EXECUTIONS_RETRY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobExecutionsRetryConfig").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::jobExecutionsRetryConfig)).setter(CreateJobTemplateRequest.setter(Builder::jobExecutionsRetryConfig)).constructor(JobExecutionsRetryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRetryConfig").build()}).build();
    private static final SdkField<List<MaintenanceWindow>> MAINTENANCE_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("maintenanceWindows").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::maintenanceWindows)).setter(CreateJobTemplateRequest.setter(Builder::maintenanceWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESTINATION_PACKAGE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinationPackageVersions").getter(CreateJobTemplateRequest.getter(CreateJobTemplateRequest::destinationPackageVersions)).setter(CreateJobTemplateRequest.setter(Builder::destinationPackageVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPackageVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TEMPLATE_ID_FIELD, JOB_ARN_FIELD, DOCUMENT_SOURCE_FIELD, DOCUMENT_FIELD, DESCRIPTION_FIELD, PRESIGNED_URL_CONFIG_FIELD, JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, ABORT_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD, TAGS_FIELD, JOB_EXECUTIONS_RETRY_CONFIG_FIELD, MAINTENANCE_WINDOWS_FIELD, DESTINATION_PACKAGE_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateJobTemplateRequest.memberNameToFieldInitializer();
    private final String jobTemplateId;
    private final String jobArn;
    private final String documentSource;
    private final String document;
    private final String description;
    private final PresignedUrlConfig presignedUrlConfig;
    private final JobExecutionsRolloutConfig jobExecutionsRolloutConfig;
    private final AbortConfig abortConfig;
    private final TimeoutConfig timeoutConfig;
    private final List<Tag> tags;
    private final JobExecutionsRetryConfig jobExecutionsRetryConfig;
    private final List<MaintenanceWindow> maintenanceWindows;
    private final List<String> destinationPackageVersions;

    private CreateJobTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.jobTemplateId = builder.jobTemplateId;
        this.jobArn = builder.jobArn;
        this.documentSource = builder.documentSource;
        this.document = builder.document;
        this.description = builder.description;
        this.presignedUrlConfig = builder.presignedUrlConfig;
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
        this.abortConfig = builder.abortConfig;
        this.timeoutConfig = builder.timeoutConfig;
        this.tags = builder.tags;
        this.jobExecutionsRetryConfig = builder.jobExecutionsRetryConfig;
        this.maintenanceWindows = builder.maintenanceWindows;
        this.destinationPackageVersions = builder.destinationPackageVersions;
    }

    public final String jobTemplateId() {
        return this.jobTemplateId;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String documentSource() {
        return this.documentSource;
    }

    public final String document() {
        return this.document;
    }

    public final String description() {
        return this.description;
    }

    public final PresignedUrlConfig presignedUrlConfig() {
        return this.presignedUrlConfig;
    }

    public final JobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return this.jobExecutionsRolloutConfig;
    }

    public final AbortConfig abortConfig() {
        return this.abortConfig;
    }

    public final TimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final JobExecutionsRetryConfig jobExecutionsRetryConfig() {
        return this.jobExecutionsRetryConfig;
    }

    public final boolean hasMaintenanceWindows() {
        return this.maintenanceWindows != null && !(this.maintenanceWindows instanceof SdkAutoConstructList);
    }

    public final List<MaintenanceWindow> maintenanceWindows() {
        return this.maintenanceWindows;
    }

    public final boolean hasDestinationPackageVersions() {
        return this.destinationPackageVersions != null && !(this.destinationPackageVersions instanceof SdkAutoConstructList);
    }

    public final List<String> destinationPackageVersions() {
        return this.destinationPackageVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.presignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionsRetryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMaintenanceWindows() ? this.maintenanceWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPackageVersions() ? this.destinationPackageVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobTemplateRequest)) {
            return false;
        }
        CreateJobTemplateRequest other = (CreateJobTemplateRequest)((Object)obj);
        return Objects.equals(this.jobTemplateId(), other.jobTemplateId()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.documentSource(), other.documentSource()) && Objects.equals(this.document(), other.document()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.presignedUrlConfig(), other.presignedUrlConfig()) && Objects.equals(this.jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig()) && Objects.equals(this.abortConfig(), other.abortConfig()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.jobExecutionsRetryConfig(), other.jobExecutionsRetryConfig()) && this.hasMaintenanceWindows() == other.hasMaintenanceWindows() && Objects.equals(this.maintenanceWindows(), other.maintenanceWindows()) && this.hasDestinationPackageVersions() == other.hasDestinationPackageVersions() && Objects.equals(this.destinationPackageVersions(), other.destinationPackageVersions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobTemplateRequest").add("JobTemplateId", (Object)this.jobTemplateId()).add("JobArn", (Object)this.jobArn()).add("DocumentSource", (Object)this.documentSource()).add("Document", (Object)this.document()).add("Description", (Object)this.description()).add("PresignedUrlConfig", (Object)this.presignedUrlConfig()).add("JobExecutionsRolloutConfig", (Object)this.jobExecutionsRolloutConfig()).add("AbortConfig", (Object)this.abortConfig()).add("TimeoutConfig", (Object)this.timeoutConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("JobExecutionsRetryConfig", (Object)this.jobExecutionsRetryConfig()).add("MaintenanceWindows", this.hasMaintenanceWindows() ? this.maintenanceWindows() : null).add("DestinationPackageVersions", this.hasDestinationPackageVersions() ? this.destinationPackageVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobTemplateId": {
                return Optional.ofNullable(clazz.cast(this.jobTemplateId()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "documentSource": {
                return Optional.ofNullable(clazz.cast(this.documentSource()));
            }
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "presignedUrlConfig": {
                return Optional.ofNullable(clazz.cast(this.presignedUrlConfig()));
            }
            case "jobExecutionsRolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionsRolloutConfig()));
            }
            case "abortConfig": {
                return Optional.ofNullable(clazz.cast(this.abortConfig()));
            }
            case "timeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "jobExecutionsRetryConfig": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionsRetryConfig()));
            }
            case "maintenanceWindows": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindows()));
            }
            case "destinationPackageVersions": {
                return Optional.ofNullable(clazz.cast(this.destinationPackageVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobTemplateId", JOB_TEMPLATE_ID_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("documentSource", DOCUMENT_SOURCE_FIELD);
        map.put("document", DOCUMENT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("presignedUrlConfig", PRESIGNED_URL_CONFIG_FIELD);
        map.put("jobExecutionsRolloutConfig", JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD);
        map.put("abortConfig", ABORT_CONFIG_FIELD);
        map.put("timeoutConfig", TIMEOUT_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("jobExecutionsRetryConfig", JOB_EXECUTIONS_RETRY_CONFIG_FIELD);
        map.put("maintenanceWindows", MAINTENANCE_WINDOWS_FIELD);
        map.put("destinationPackageVersions", DESTINATION_PACKAGE_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateJobTemplateRequest, T> g) {
        return obj -> g.apply((CreateJobTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String jobTemplateId;
        private String jobArn;
        private String documentSource;
        private String document;
        private String description;
        private PresignedUrlConfig presignedUrlConfig;
        private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;
        private AbortConfig abortConfig;
        private TimeoutConfig timeoutConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private JobExecutionsRetryConfig jobExecutionsRetryConfig;
        private List<MaintenanceWindow> maintenanceWindows = DefaultSdkAutoConstructList.getInstance();
        private List<String> destinationPackageVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobTemplateRequest model) {
            super(model);
            this.jobTemplateId(model.jobTemplateId);
            this.jobArn(model.jobArn);
            this.documentSource(model.documentSource);
            this.document(model.document);
            this.description(model.description);
            this.presignedUrlConfig(model.presignedUrlConfig);
            this.jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
            this.abortConfig(model.abortConfig);
            this.timeoutConfig(model.timeoutConfig);
            this.tags(model.tags);
            this.jobExecutionsRetryConfig(model.jobExecutionsRetryConfig);
            this.maintenanceWindows(model.maintenanceWindows);
            this.destinationPackageVersions(model.destinationPackageVersions);
        }

        public final String getJobTemplateId() {
            return this.jobTemplateId;
        }

        public final void setJobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
        }

        @Override
        public final Builder jobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getDocumentSource() {
            return this.documentSource;
        }

        public final void setDocumentSource(String documentSource) {
            this.documentSource = documentSource;
        }

        @Override
        public final Builder documentSource(String documentSource) {
            this.documentSource = documentSource;
            return this;
        }

        public final String getDocument() {
            return this.document;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PresignedUrlConfig.Builder getPresignedUrlConfig() {
            return this.presignedUrlConfig != null ? this.presignedUrlConfig.toBuilder() : null;
        }

        public final void setPresignedUrlConfig(PresignedUrlConfig.BuilderImpl presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig != null ? presignedUrlConfig.build() : null;
        }

        @Override
        public final Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig;
            return this;
        }

        public final JobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return this.jobExecutionsRolloutConfig != null ? this.jobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        @Override
        public final Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final AbortConfig.Builder getAbortConfig() {
            return this.abortConfig != null ? this.abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(AbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        public final Builder abortConfig(AbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final JobExecutionsRetryConfig.Builder getJobExecutionsRetryConfig() {
            return this.jobExecutionsRetryConfig != null ? this.jobExecutionsRetryConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRetryConfig(JobExecutionsRetryConfig.BuilderImpl jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig != null ? jobExecutionsRetryConfig.build() : null;
        }

        @Override
        public final Builder jobExecutionsRetryConfig(JobExecutionsRetryConfig jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig;
            return this;
        }

        public final List<MaintenanceWindow.Builder> getMaintenanceWindows() {
            List<MaintenanceWindow.Builder> result = MaintenanceWindowsCopier.copyToBuilder(this.maintenanceWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMaintenanceWindows(Collection<MaintenanceWindow.BuilderImpl> maintenanceWindows) {
            this.maintenanceWindows = MaintenanceWindowsCopier.copyFromBuilder(maintenanceWindows);
        }

        @Override
        public final Builder maintenanceWindows(Collection<MaintenanceWindow> maintenanceWindows) {
            this.maintenanceWindows = MaintenanceWindowsCopier.copy(maintenanceWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceWindows(MaintenanceWindow ... maintenanceWindows) {
            this.maintenanceWindows(Arrays.asList(maintenanceWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceWindows(Consumer<MaintenanceWindow.Builder> ... maintenanceWindows) {
            this.maintenanceWindows(Stream.of(maintenanceWindows).map(c -> (MaintenanceWindow)((MaintenanceWindow.Builder)MaintenanceWindow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDestinationPackageVersions() {
            if (this.destinationPackageVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPackageVersions;
        }

        public final void setDestinationPackageVersions(Collection<String> destinationPackageVersions) {
            this.destinationPackageVersions = DestinationPackageVersionsCopier.copy(destinationPackageVersions);
        }

        @Override
        public final Builder destinationPackageVersions(Collection<String> destinationPackageVersions) {
            this.destinationPackageVersions = DestinationPackageVersionsCopier.copy(destinationPackageVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPackageVersions(String ... destinationPackageVersions) {
            this.destinationPackageVersions(Arrays.asList(destinationPackageVersions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobTemplateRequest build() {
            return new CreateJobTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobTemplateRequest> {
        public Builder jobTemplateId(String var1);

        public Builder jobArn(String var1);

        public Builder documentSource(String var1);

        public Builder document(String var1);

        public Builder description(String var1);

        public Builder presignedUrlConfig(PresignedUrlConfig var1);

        default public Builder presignedUrlConfig(Consumer<PresignedUrlConfig.Builder> presignedUrlConfig) {
            return this.presignedUrlConfig((PresignedUrlConfig)((PresignedUrlConfig.Builder)PresignedUrlConfig.builder().applyMutation(presignedUrlConfig)).build());
        }

        public Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig var1);

        default public Builder jobExecutionsRolloutConfig(Consumer<JobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return this.jobExecutionsRolloutConfig((JobExecutionsRolloutConfig)((JobExecutionsRolloutConfig.Builder)JobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)).build());
        }

        public Builder abortConfig(AbortConfig var1);

        default public Builder abortConfig(Consumer<AbortConfig.Builder> abortConfig) {
            return this.abortConfig((AbortConfig)((AbortConfig.Builder)AbortConfig.builder().applyMutation(abortConfig)).build());
        }

        public Builder timeoutConfig(TimeoutConfig var1);

        default public Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return this.timeoutConfig((TimeoutConfig)((TimeoutConfig.Builder)TimeoutConfig.builder().applyMutation(timeoutConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder jobExecutionsRetryConfig(JobExecutionsRetryConfig var1);

        default public Builder jobExecutionsRetryConfig(Consumer<JobExecutionsRetryConfig.Builder> jobExecutionsRetryConfig) {
            return this.jobExecutionsRetryConfig((JobExecutionsRetryConfig)((JobExecutionsRetryConfig.Builder)JobExecutionsRetryConfig.builder().applyMutation(jobExecutionsRetryConfig)).build());
        }

        public Builder maintenanceWindows(Collection<MaintenanceWindow> var1);

        public Builder maintenanceWindows(MaintenanceWindow ... var1);

        public Builder maintenanceWindows(Consumer<MaintenanceWindow.Builder> ... var1);

        public Builder destinationPackageVersions(Collection<String> var1);

        public Builder destinationPackageVersions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

