/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.PrincipalThingObject;
import software.amazon.awssdk.services.iot.model.PrincipalThingObjectsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPrincipalThingsV2Response
extends IotResponse
implements ToCopyableBuilder<Builder, ListPrincipalThingsV2Response> {
    private static final SdkField<List<PrincipalThingObject>> PRINCIPAL_THING_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("principalThingObjects").getter(ListPrincipalThingsV2Response.getter(ListPrincipalThingsV2Response::principalThingObjects)).setter(ListPrincipalThingsV2Response.setter(Builder::principalThingObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalThingObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalThingObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPrincipalThingsV2Response.getter(ListPrincipalThingsV2Response::nextToken)).setter(ListPrincipalThingsV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_THING_OBJECTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPrincipalThingsV2Response.memberNameToFieldInitializer();
    private final List<PrincipalThingObject> principalThingObjects;
    private final String nextToken;

    private ListPrincipalThingsV2Response(BuilderImpl builder) {
        super(builder);
        this.principalThingObjects = builder.principalThingObjects;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPrincipalThingObjects() {
        return this.principalThingObjects != null && !(this.principalThingObjects instanceof SdkAutoConstructList);
    }

    public final List<PrincipalThingObject> principalThingObjects() {
        return this.principalThingObjects;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipalThingObjects() ? this.principalThingObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalThingsV2Response)) {
            return false;
        }
        ListPrincipalThingsV2Response other = (ListPrincipalThingsV2Response)((Object)obj);
        return this.hasPrincipalThingObjects() == other.hasPrincipalThingObjects() && Objects.equals(this.principalThingObjects(), other.principalThingObjects()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPrincipalThingsV2Response").add("PrincipalThingObjects", this.hasPrincipalThingObjects() ? this.principalThingObjects() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principalThingObjects": {
                return Optional.ofNullable(clazz.cast(this.principalThingObjects()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("principalThingObjects", PRINCIPAL_THING_OBJECTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPrincipalThingsV2Response, T> g) {
        return obj -> g.apply((ListPrincipalThingsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<PrincipalThingObject> principalThingObjects = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalThingsV2Response model) {
            super(model);
            this.principalThingObjects(model.principalThingObjects);
            this.nextToken(model.nextToken);
        }

        public final List<PrincipalThingObject.Builder> getPrincipalThingObjects() {
            List<PrincipalThingObject.Builder> result = PrincipalThingObjectsCopier.copyToBuilder(this.principalThingObjects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipalThingObjects(Collection<PrincipalThingObject.BuilderImpl> principalThingObjects) {
            this.principalThingObjects = PrincipalThingObjectsCopier.copyFromBuilder(principalThingObjects);
        }

        @Override
        public final Builder principalThingObjects(Collection<PrincipalThingObject> principalThingObjects) {
            this.principalThingObjects = PrincipalThingObjectsCopier.copy(principalThingObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalThingObjects(PrincipalThingObject ... principalThingObjects) {
            this.principalThingObjects(Arrays.asList(principalThingObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalThingObjects(Consumer<PrincipalThingObject.Builder> ... principalThingObjects) {
            this.principalThingObjects(Stream.of(principalThingObjects).map(c -> (PrincipalThingObject)((PrincipalThingObject.Builder)PrincipalThingObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPrincipalThingsV2Response build() {
            return new ListPrincipalThingsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPrincipalThingsV2Response> {
        public Builder principalThingObjects(Collection<PrincipalThingObject> var1);

        public Builder principalThingObjects(PrincipalThingObject ... var1);

        public Builder principalThingObjects(Consumer<PrincipalThingObject.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

