/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse;

public class ListPrincipalThingsIterable
implements SdkIterable<ListPrincipalThingsResponse> {
    private final IotClient client;
    private final ListPrincipalThingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPrincipalThingsIterable(IotClient client, ListPrincipalThingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPrincipalThingsResponseFetcher();
    }

    public Iterator<ListPrincipalThingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> things() {
        Function<ListPrincipalThingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.things() != null) {
                return response.things().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPrincipalThingsResponseFetcher
    implements SyncPageFetcher<ListPrincipalThingsResponse> {
        private ListPrincipalThingsResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalThingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPrincipalThingsResponse nextPage(ListPrincipalThingsResponse previousPage) {
            if (previousPage == null) {
                return ListPrincipalThingsIterable.this.client.listPrincipalThings(ListPrincipalThingsIterable.this.firstRequest);
            }
            return ListPrincipalThingsIterable.this.client.listPrincipalThings((ListPrincipalThingsRequest)((Object)ListPrincipalThingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

