/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsV2Request;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsV2Response;
import software.amazon.awssdk.services.iot.model.ThingPrincipalObject;

public class ListThingPrincipalsV2Iterable
implements SdkIterable<ListThingPrincipalsV2Response> {
    private final IotClient client;
    private final ListThingPrincipalsV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingPrincipalsV2Iterable(IotClient client, ListThingPrincipalsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListThingPrincipalsV2ResponseFetcher();
    }

    public Iterator<ListThingPrincipalsV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ThingPrincipalObject> thingPrincipalObjects() {
        Function<ListThingPrincipalsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.thingPrincipalObjects() != null) {
                return response.thingPrincipalObjects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingPrincipalsV2ResponseFetcher
    implements SyncPageFetcher<ListThingPrincipalsV2Response> {
        private ListThingPrincipalsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListThingPrincipalsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingPrincipalsV2Response nextPage(ListThingPrincipalsV2Response previousPage) {
            if (previousPage == null) {
                return ListThingPrincipalsV2Iterable.this.client.listThingPrincipalsV2(ListThingPrincipalsV2Iterable.this.firstRequest);
            }
            return ListThingPrincipalsV2Iterable.this.client.listThingPrincipalsV2((ListThingPrincipalsV2Request)((Object)ListThingPrincipalsV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

